@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The managed application provider authorization.
 * @property principalId The provider's principal identifier. This is the identity that the provider will use to call ARM to manage the managed application resources.
 * @property roleDefinitionId The provider's role definition identifier. This role will define all the permissions that the provider must have on the managed application's container resource group. This role definition cannot have permission to delete the resource group.
 */
public data class ApplicationAuthorizationResponse(
    public val principalId: String,
    public val roleDefinitionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.solutions.outputs.ApplicationAuthorizationResponse): ApplicationAuthorizationResponse = ApplicationAuthorizationResponse(
            principalId = javaType.principalId(),
            roleDefinitionId = javaType.roleDefinitionId(),
        )
    }
}
