@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Application definition artifact.
 * @property name The managed application definition artifact name.
 * @property type The managed application definition artifact type.
 * @property uri The managed application definition artifact blob uri.
 */
public data class ApplicationDefinitionArtifactResponse(
    public val name: String,
    public val type: String,
    public val uri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.solutions.outputs.ApplicationDefinitionArtifactResponse): ApplicationDefinitionArtifactResponse = ApplicationDefinitionArtifactResponse(
            name = javaType.name(),
            type = javaType.type(),
            uri = javaType.uri(),
        )
    }
}
