@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Managed application Jit access policy.
 * @property jitAccessEnabled Whether the JIT access is enabled.
 * @property jitApprovalMode JIT approval mode.
 * @property jitApprovers The JIT approvers
 * @property maximumJitAccessDuration The maximum duration JIT access is granted. This is an ISO8601 time period value.
 */
public data class ApplicationJitAccessPolicyResponse(
    public val jitAccessEnabled: Boolean,
    public val jitApprovalMode: String? = null,
    public val jitApprovers: List<JitApproverDefinitionResponse>? = null,
    public val maximumJitAccessDuration: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.solutions.outputs.ApplicationJitAccessPolicyResponse): ApplicationJitAccessPolicyResponse = ApplicationJitAccessPolicyResponse(
            jitAccessEnabled = javaType.jitAccessEnabled(),
            jitApprovalMode = javaType.jitApprovalMode().map({ args0 -> args0 }).orElse(null),
            jitApprovers = javaType.jitApprovers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.solutions.kotlin.outputs.JitApproverDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
            maximumJitAccessDuration = javaType.maximumJitAccessDuration().map({ args0 -> args0 }).orElse(null),
        )
    }
}
