@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Managed application locking policy.
 * @property allowedActions The deny assignment excluded actions.
 * @property allowedDataActions The deny assignment excluded data actions.
 */
public data class ApplicationPackageLockingPolicyDefinitionResponse(
    public val allowedActions: List<String>? = null,
    public val allowedDataActions: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.solutions.outputs.ApplicationPackageLockingPolicyDefinitionResponse): ApplicationPackageLockingPolicyDefinitionResponse =
            ApplicationPackageLockingPolicyDefinitionResponse(
                allowedActions = javaType.allowedActions().map({ args0 -> args0 }),
                allowedDataActions = javaType.allowedDataActions().map({ args0 -> args0 }),
            )
    }
}
