@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Managed application policy.
 * @property name The policy name
 * @property parameters The policy parameters.
 * @property policyDefinitionId The policy definition Id.
 */
public data class ApplicationPolicyResponse(
    public val name: String? = null,
    public val parameters: String? = null,
    public val policyDefinitionId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.solutions.outputs.ApplicationPolicyResponse): ApplicationPolicyResponse = ApplicationPolicyResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 -> args0 }).orElse(null),
            policyDefinitionId = javaType.policyDefinitionId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
