@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * JIT approver definition.
 * @property displayName The approver display name.
 * @property id The approver service principal Id.
 * @property type The approver type.
 */
public data class JitApproverDefinitionResponse(
    public val displayName: String? = null,
    public val id: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.solutions.outputs.JitApproverDefinitionResponse): JitApproverDefinitionResponse = JitApproverDefinitionResponse(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
