@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The managed identity token for the managed app resource.
 * @property accessToken The requested access token.
 * @property authorizationAudience The aud (audience) the access token was request for. This is the same as what was provided in the listTokens request.
 * @property expiresIn The number of seconds the access token will be valid.
 * @property expiresOn The timespan when the access token expires. This is represented as the number of seconds from epoch.
 * @property notBefore The timespan when the access token takes effect. This is represented as the number of seconds from epoch.
 * @property resourceId The Azure resource ID for the issued token. This is either the managed application ID or the user-assigned identity ID.
 * @property tokenType The type of the token.
 */
public data class ManagedIdentityTokenResponse(
    public val accessToken: String? = null,
    public val authorizationAudience: String? = null,
    public val expiresIn: String? = null,
    public val expiresOn: String? = null,
    public val notBefore: String? = null,
    public val resourceId: String? = null,
    public val tokenType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.solutions.outputs.ManagedIdentityTokenResponse): ManagedIdentityTokenResponse = ManagedIdentityTokenResponse(
            accessToken = javaType.accessToken().map({ args0 -> args0 }).orElse(null),
            authorizationAudience = javaType.authorizationAudience().map({ args0 -> args0 }).orElse(null),
            expiresIn = javaType.expiresIn().map({ args0 -> args0 }).orElse(null),
            expiresOn = javaType.expiresOn().map({ args0 -> args0 }).orElse(null),
            notBefore = javaType.notBefore().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            tokenType = javaType.tokenType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
