@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Plan for the managed application.
 * @property name The plan name.
 * @property product The product code.
 * @property promotionCode The promotion code.
 * @property publisher The publisher ID.
 * @property version The plan's version.
 */
public data class PlanResponse(
    public val name: String,
    public val product: String,
    public val promotionCode: String? = null,
    public val publisher: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.solutions.outputs.PlanResponse): PlanResponse = PlanResponse(
            name = javaType.name(),
            product = javaType.product(),
            promotionCode = javaType.promotionCode().map({ args0 -> args0 }).orElse(null),
            publisher = javaType.publisher(),
            version = javaType.version(),
        )
    }
}
