@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.kotlin.outputs.DatabaseIdentityResponse
import com.pulumi.azurenative.sql.kotlin.outputs.SkuResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.sql.kotlin.outputs.DatabaseIdentityResponse.Companion.toKotlin as databaseIdentityResponseToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin

/**
 * Builder for [Database].
 */
@PulumiTagMarker
public class DatabaseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DatabaseArgs = DatabaseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DatabaseArgsBuilder.() -> Unit) {
        val builder = DatabaseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Database {
        val builtJavaResource = com.pulumi.azurenative.sql.Database(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Database(builtJavaResource)
    }
}

/**
 * A database resource.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2014-04-01, 2019-06-01-preview, 2020-02-02-preview, 2020-08-01-preview, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Creates a VCore database by specifying service objective name.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var database = new AzureNative.Sql.Database("database", new()
 *     {
 *         DatabaseName = "testdb",
 *         Location = "southeastasia",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         ServerName = "testsvr",
 *         Sku = new AzureNative.Sql.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Family = "Gen4",
 *             Name = "BC",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabase(ctx, "database", &sql.DatabaseArgs{
 * 			DatabaseName:      pulumi.String("testdb"),
 * 			Location:          pulumi.String("southeastasia"),
 * 			ResourceGroupName: pulumi.String("Default-SQL-SouthEastAsia"),
 * 			ServerName:        pulumi.String("testsvr"),
 * 			Sku: &sql.SkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Family:   pulumi.String("Gen4"),
 * 				Name:     pulumi.String("BC"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.Database;
 * import com.pulumi.azurenative.sql.DatabaseArgs;
 * import com.pulumi.azurenative.sql.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var database = new Database("database", DatabaseArgs.builder()
 *             .databaseName("testdb")
 *             .location("southeastasia")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .serverName("testsvr")
 *             .sku(SkuArgs.builder()
 *                 .capacity(2)
 *                 .family("Gen4")
 *                 .name("BC")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a VCore database by specifying sku name and capacity.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var database = new AzureNative.Sql.Database("database", new()
 *     {
 *         DatabaseName = "testdb",
 *         Location = "southeastasia",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         ServerName = "testsvr",
 *         Sku = new AzureNative.Sql.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "BC_Gen4",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabase(ctx, "database", &sql.DatabaseArgs{
 * 			DatabaseName:      pulumi.String("testdb"),
 * 			Location:          pulumi.String("southeastasia"),
 * 			ResourceGroupName: pulumi.String("Default-SQL-SouthEastAsia"),
 * 			ServerName:        pulumi.String("testsvr"),
 * 			Sku: &sql.SkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Name:     pulumi.String("BC_Gen4"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.Database;
 * import com.pulumi.azurenative.sql.DatabaseArgs;
 * import com.pulumi.azurenative.sql.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var database = new Database("database", DatabaseArgs.builder()
 *             .databaseName("testdb")
 *             .location("southeastasia")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .serverName("testsvr")
 *             .sku(SkuArgs.builder()
 *                 .capacity(2)
 *                 .name("BC_Gen4")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a data warehouse database as a cross-subscription restore from a backup of a dropped database.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var database = new AzureNative.Sql.Database("database", new()
 *     {
 *         CreateMode = AzureNative.Sql.CreateMode.Restore,
 *         DatabaseName = "testdw",
 *         Location = "southeastasia",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         ServerName = "testsvr",
 *         SourceResourceId = "/subscriptions/55555555-6666-7777-8888-999999999999/resourceGroups/Default-SQL-SouthEastAsia/providers/Microsoft.Sql/servers/srcsvr/restorableDroppedDatabases/srcdw,131403269876900000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabase(ctx, "database", &sql.DatabaseArgs{
 * 			CreateMode:        pulumi.String(sql.CreateModeRestore),
 * 			DatabaseName:      pulumi.String("testdw"),
 * 			Location:          pulumi.String("southeastasia"),
 * 			ResourceGroupName: pulumi.String("Default-SQL-SouthEastAsia"),
 * 			ServerName:        pulumi.String("testsvr"),
 * 			SourceResourceId:  pulumi.String("/subscriptions/55555555-6666-7777-8888-999999999999/resourceGroups/Default-SQL-SouthEastAsia/providers/Microsoft.Sql/servers/srcsvr/restorableDroppedDatabases/srcdw,131403269876900000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.Database;
 * import com.pulumi.azurenative.sql.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var database = new Database("database", DatabaseArgs.builder()
 *             .createMode("Restore")
 *             .databaseName("testdw")
 *             .location("southeastasia")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .serverName("testsvr")
 *             .sourceResourceId("/subscriptions/55555555-6666-7777-8888-999999999999/resourceGroups/Default-SQL-SouthEastAsia/providers/Microsoft.Sql/servers/srcsvr/restorableDroppedDatabases/srcdw,131403269876900000")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a data warehouse database as a cross-subscription restore from a geo-backup.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var database = new AzureNative.Sql.Database("database", new()
 *     {
 *         CreateMode = AzureNative.Sql.CreateMode.Recovery,
 *         DatabaseName = "testdw",
 *         Location = "westus",
 *         ResourceGroupName = "Default-SQL-WestUS",
 *         ServerName = "testsvr",
 *         SourceResourceId = "/subscriptions/55555555-6666-7777-8888-999999999999/resourceGroups/Default-SQL-EastUS/providers/Microsoft.Sql/servers/srcsvr/recoverabledatabases/srcdw",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabase(ctx, "database", &sql.DatabaseArgs{
 * 			CreateMode:        pulumi.String(sql.CreateModeRecovery),
 * 			DatabaseName:      pulumi.String("testdw"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("Default-SQL-WestUS"),
 * 			ServerName:        pulumi.String("testsvr"),
 * 			SourceResourceId:  pulumi.String("/subscriptions/55555555-6666-7777-8888-999999999999/resourceGroups/Default-SQL-EastUS/providers/Microsoft.Sql/servers/srcsvr/recoverabledatabases/srcdw"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.Database;
 * import com.pulumi.azurenative.sql.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var database = new Database("database", DatabaseArgs.builder()
 *             .createMode("Recovery")
 *             .databaseName("testdw")
 *             .location("westus")
 *             .resourceGroupName("Default-SQL-WestUS")
 *             .serverName("testsvr")
 *             .sourceResourceId("/subscriptions/55555555-6666-7777-8888-999999999999/resourceGroups/Default-SQL-EastUS/providers/Microsoft.Sql/servers/srcsvr/recoverabledatabases/srcdw")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a data warehouse database as a cross-subscription restore from a restore point of an existing database.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var database = new AzureNative.Sql.Database("database", new()
 *     {
 *         CreateMode = AzureNative.Sql.CreateMode.PointInTimeRestore,
 *         DatabaseName = "testdw",
 *         Location = "southeastasia",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         RestorePointInTime = "2022-01-22T05:35:31.503Z",
 *         ServerName = "testsvr",
 *         SourceResourceId = "/subscriptions/55555555-6666-7777-8888-999999999999/resourceGroups/Default-SQL-SouthEastAsia/providers/Microsoft.Sql/servers/srcsvr/databases/srcdw",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabase(ctx, "database", &sql.DatabaseArgs{
 * 			CreateMode:         pulumi.String(sql.CreateModePointInTimeRestore),
 * 			DatabaseName:       pulumi.String("testdw"),
 * 			Location:           pulumi.String("southeastasia"),
 * 			ResourceGroupName:  pulumi.String("Default-SQL-SouthEastAsia"),
 * 			RestorePointInTime: pulumi.String("2022-01-22T05:35:31.503Z"),
 * 			ServerName:         pulumi.String("testsvr"),
 * 			SourceResourceId:   pulumi.String("/subscriptions/55555555-6666-7777-8888-999999999999/resourceGroups/Default-SQL-SouthEastAsia/providers/Microsoft.Sql/servers/srcsvr/databases/srcdw"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.Database;
 * import com.pulumi.azurenative.sql.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var database = new Database("database", DatabaseArgs.builder()
 *             .createMode("PointInTimeRestore")
 *             .databaseName("testdw")
 *             .location("southeastasia")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .restorePointInTime("2022-01-22T05:35:31.503Z")
 *             .serverName("testsvr")
 *             .sourceResourceId("/subscriptions/55555555-6666-7777-8888-999999999999/resourceGroups/Default-SQL-SouthEastAsia/providers/Microsoft.Sql/servers/srcsvr/databases/srcdw")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a database as a copy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var database = new AzureNative.Sql.Database("database", new()
 *     {
 *         CreateMode = AzureNative.Sql.CreateMode.Copy,
 *         DatabaseName = "dbcopy",
 *         Location = "southeastasia",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         ServerName = "testsvr",
 *         Sku = new AzureNative.Sql.Inputs.SkuArgs
 *         {
 *             Name = "S0",
 *             Tier = "Standard",
 *         },
 *         SourceDatabaseId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-SouthEastAsia/providers/Microsoft.Sql/servers/testsvr/databases/testdb",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabase(ctx, "database", &sql.DatabaseArgs{
 * 			CreateMode:        pulumi.String(sql.CreateModeCopy),
 * 			DatabaseName:      pulumi.String("dbcopy"),
 * 			Location:          pulumi.String("southeastasia"),
 * 			ResourceGroupName: pulumi.String("Default-SQL-SouthEastAsia"),
 * 			ServerName:        pulumi.String("testsvr"),
 * 			Sku: &sql.SkuArgs{
 * 				Name: pulumi.String("S0"),
 * 				Tier: pulumi.String("Standard"),
 * 			},
 * 			SourceDatabaseId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-SouthEastAsia/providers/Microsoft.Sql/servers/testsvr/databases/testdb"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.Database;
 * import com.pulumi.azurenative.sql.DatabaseArgs;
 * import com.pulumi.azurenative.sql.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var database = new Database("database", DatabaseArgs.builder()
 *             .createMode("Copy")
 *             .databaseName("dbcopy")
 *             .location("southeastasia")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .serverName("testsvr")
 *             .sku(SkuArgs.builder()
 *                 .name("S0")
 *                 .tier("Standard")
 *                 .build())
 *             .sourceDatabaseId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-SouthEastAsia/providers/Microsoft.Sql/servers/testsvr/databases/testdb")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a database as an on-line secondary.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var database = new AzureNative.Sql.Database("database", new()
 *     {
 *         CreateMode = AzureNative.Sql.CreateMode.Secondary,
 *         DatabaseName = "testdb",
 *         Location = "southeastasia",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         SecondaryType = AzureNative.Sql.SecondaryType.Geo,
 *         ServerName = "testsvr",
 *         Sku = new AzureNative.Sql.Inputs.SkuArgs
 *         {
 *             Name = "S0",
 *             Tier = "Standard",
 *         },
 *         SourceDatabaseId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-NorthEurope/providers/Microsoft.Sql/servers/testsvr1/databases/testdb",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabase(ctx, "database", &sql.DatabaseArgs{
 * 			CreateMode:        pulumi.String(sql.CreateModeSecondary),
 * 			DatabaseName:      pulumi.String("testdb"),
 * 			Location:          pulumi.String("southeastasia"),
 * 			ResourceGroupName: pulumi.String("Default-SQL-SouthEastAsia"),
 * 			SecondaryType:     pulumi.String(sql.SecondaryTypeGeo),
 * 			ServerName:        pulumi.String("testsvr"),
 * 			Sku: &sql.SkuArgs{
 * 				Name: pulumi.String("S0"),
 * 				Tier: pulumi.String("Standard"),
 * 			},
 * 			SourceDatabaseId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-NorthEurope/providers/Microsoft.Sql/servers/testsvr1/databases/testdb"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.Database;
 * import com.pulumi.azurenative.sql.DatabaseArgs;
 * import com.pulumi.azurenative.sql.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var database = new Database("database", DatabaseArgs.builder()
 *             .createMode("Secondary")
 *             .databaseName("testdb")
 *             .location("southeastasia")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .secondaryType("Geo")
 *             .serverName("testsvr")
 *             .sku(SkuArgs.builder()
 *                 .name("S0")
 *                 .tier("Standard")
 *                 .build())
 *             .sourceDatabaseId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-NorthEurope/providers/Microsoft.Sql/servers/testsvr1/databases/testdb")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a database as named replica secondary.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var database = new AzureNative.Sql.Database("database", new()
 *     {
 *         CreateMode = AzureNative.Sql.CreateMode.Secondary,
 *         DatabaseName = "testdb",
 *         Location = "southeastasia",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         SecondaryType = AzureNative.Sql.SecondaryType.Named,
 *         ServerName = "testsvr",
 *         Sku = new AzureNative.Sql.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "HS_Gen4",
 *             Tier = "Hyperscale",
 *         },
 *         SourceDatabaseId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-NorthEurope/providers/Microsoft.Sql/servers/testsvr1/databases/primarydb",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabase(ctx, "database", &sql.DatabaseArgs{
 * 			CreateMode:        pulumi.String(sql.CreateModeSecondary),
 * 			DatabaseName:      pulumi.String("testdb"),
 * 			Location:          pulumi.String("southeastasia"),
 * 			ResourceGroupName: pulumi.String("Default-SQL-SouthEastAsia"),
 * 			SecondaryType:     pulumi.String(sql.SecondaryTypeNamed),
 * 			ServerName:        pulumi.String("testsvr"),
 * 			Sku: &sql.SkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Name:     pulumi.String("HS_Gen4"),
 * 				Tier:     pulumi.String("Hyperscale"),
 * 			},
 * 			SourceDatabaseId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-NorthEurope/providers/Microsoft.Sql/servers/testsvr1/databases/primarydb"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.Database;
 * import com.pulumi.azurenative.sql.DatabaseArgs;
 * import com.pulumi.azurenative.sql.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var database = new Database("database", DatabaseArgs.builder()
 *             .createMode("Secondary")
 *             .databaseName("testdb")
 *             .location("southeastasia")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .secondaryType("Named")
 *             .serverName("testsvr")
 *             .sku(SkuArgs.builder()
 *                 .capacity(2)
 *                 .name("HS_Gen4")
 *                 .tier("Hyperscale")
 *                 .build())
 *             .sourceDatabaseId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-NorthEurope/providers/Microsoft.Sql/servers/testsvr1/databases/primarydb")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a database from PointInTimeRestore.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var database = new AzureNative.Sql.Database("database", new()
 *     {
 *         CreateMode = AzureNative.Sql.CreateMode.PointInTimeRestore,
 *         DatabaseName = "dbpitr",
 *         Location = "southeastasia",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         RestorePointInTime = "2020-10-22T05:35:31.503Z",
 *         ServerName = "testsvr",
 *         SourceDatabaseId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-SoutheastAsia/providers/Microsoft.Sql/servers/testsvr/databases/testdb",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabase(ctx, "database", &sql.DatabaseArgs{
 * 			CreateMode:         pulumi.String(sql.CreateModePointInTimeRestore),
 * 			DatabaseName:       pulumi.String("dbpitr"),
 * 			Location:           pulumi.String("southeastasia"),
 * 			ResourceGroupName:  pulumi.String("Default-SQL-SouthEastAsia"),
 * 			RestorePointInTime: pulumi.String("2020-10-22T05:35:31.503Z"),
 * 			ServerName:         pulumi.String("testsvr"),
 * 			SourceDatabaseId:   pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-SoutheastAsia/providers/Microsoft.Sql/servers/testsvr/databases/testdb"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.Database;
 * import com.pulumi.azurenative.sql.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var database = new Database("database", DatabaseArgs.builder()
 *             .createMode("PointInTimeRestore")
 *             .databaseName("dbpitr")
 *             .location("southeastasia")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .restorePointInTime("2020-10-22T05:35:31.503Z")
 *             .serverName("testsvr")
 *             .sourceDatabaseId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-SoutheastAsia/providers/Microsoft.Sql/servers/testsvr/databases/testdb")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a database with default mode.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var database = new AzureNative.Sql.Database("database", new()
 *     {
 *         Collation = "SQL_Latin1_General_CP1_CI_AS",
 *         CreateMode = AzureNative.Sql.CreateMode.Default,
 *         DatabaseName = "testdb",
 *         Location = "southeastasia",
 *         MaxSizeBytes = 1073741824,
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         ServerName = "testsvr",
 *         Sku = new AzureNative.Sql.Inputs.SkuArgs
 *         {
 *             Name = "S0",
 *             Tier = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabase(ctx, "database", &sql.DatabaseArgs{
 * 			Collation:         pulumi.String("SQL_Latin1_General_CP1_CI_AS"),
 * 			CreateMode:        pulumi.String(sql.CreateModeDefault),
 * 			DatabaseName:      pulumi.String("testdb"),
 * 			Location:          pulumi.String("southeastasia"),
 * 			MaxSizeBytes:      pulumi.Float64(1073741824),
 * 			ResourceGroupName: pulumi.String("Default-SQL-SouthEastAsia"),
 * 			ServerName:        pulumi.String("testsvr"),
 * 			Sku: &sql.SkuArgs{
 * 				Name: pulumi.String("S0"),
 * 				Tier: pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.Database;
 * import com.pulumi.azurenative.sql.DatabaseArgs;
 * import com.pulumi.azurenative.sql.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var database = new Database("database", DatabaseArgs.builder()
 *             .collation("SQL_Latin1_General_CP1_CI_AS")
 *             .createMode("Default")
 *             .databaseName("testdb")
 *             .location("southeastasia")
 *             .maxSizeBytes(1073741824)
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .serverName("testsvr")
 *             .sku(SkuArgs.builder()
 *                 .name("S0")
 *                 .tier("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a database with ledger on.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var database = new AzureNative.Sql.Database("database", new()
 *     {
 *         DatabaseName = "testdb",
 *         IsLedgerOn = true,
 *         Location = "southeastasia",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         ServerName = "testsvr",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabase(ctx, "database", &sql.DatabaseArgs{
 * 			DatabaseName:      pulumi.String("testdb"),
 * 			IsLedgerOn:        pulumi.Bool(true),
 * 			Location:          pulumi.String("southeastasia"),
 * 			ResourceGroupName: pulumi.String("Default-SQL-SouthEastAsia"),
 * 			ServerName:        pulumi.String("testsvr"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.Database;
 * import com.pulumi.azurenative.sql.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var database = new Database("database", DatabaseArgs.builder()
 *             .databaseName("testdb")
 *             .isLedgerOn(true)
 *             .location("southeastasia")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .serverName("testsvr")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a database with minimum number of parameters.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var database = new AzureNative.Sql.Database("database", new()
 *     {
 *         DatabaseName = "testdb",
 *         Location = "southeastasia",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         ServerName = "testsvr",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabase(ctx, "database", &sql.DatabaseArgs{
 * 			DatabaseName:      pulumi.String("testdb"),
 * 			Location:          pulumi.String("southeastasia"),
 * 			ResourceGroupName: pulumi.String("Default-SQL-SouthEastAsia"),
 * 			ServerName:        pulumi.String("testsvr"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.Database;
 * import com.pulumi.azurenative.sql.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var database = new Database("database", DatabaseArgs.builder()
 *             .databaseName("testdb")
 *             .location("southeastasia")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .serverName("testsvr")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a database with preferred maintenance window.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var database = new AzureNative.Sql.Database("database", new()
 *     {
 *         Collation = "SQL_Latin1_General_CP1_CI_AS",
 *         CreateMode = AzureNative.Sql.CreateMode.Default,
 *         DatabaseName = "testdb",
 *         Location = "southeastasia",
 *         MaintenanceConfigurationId = "/subscriptions/00000000-1111-2222-3333-444444444444/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_SouthEastAsia_1",
 *         MaxSizeBytes = 1073741824,
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         ServerName = "testsvr",
 *         Sku = new AzureNative.Sql.Inputs.SkuArgs
 *         {
 *             Name = "S2",
 *             Tier = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabase(ctx, "database", &sql.DatabaseArgs{
 * 			Collation:                  pulumi.String("SQL_Latin1_General_CP1_CI_AS"),
 * 			CreateMode:                 pulumi.String(sql.CreateModeDefault),
 * 			DatabaseName:               pulumi.String("testdb"),
 * 			Location:                   pulumi.String("southeastasia"),
 * 			MaintenanceConfigurationId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_SouthEastAsia_1"),
 * 			MaxSizeBytes:               pulumi.Float64(1073741824),
 * 			ResourceGroupName:          pulumi.String("Default-SQL-SouthEastAsia"),
 * 			ServerName:                 pulumi.String("testsvr"),
 * 			Sku: &sql.SkuArgs{
 * 				Name: pulumi.String("S2"),
 * 				Tier: pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.Database;
 * import com.pulumi.azurenative.sql.DatabaseArgs;
 * import com.pulumi.azurenative.sql.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var database = new Database("database", DatabaseArgs.builder()
 *             .collation("SQL_Latin1_General_CP1_CI_AS")
 *             .createMode("Default")
 *             .databaseName("testdb")
 *             .location("southeastasia")
 *             .maintenanceConfigurationId("/subscriptions/00000000-1111-2222-3333-444444444444/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_SouthEastAsia_1")
 *             .maxSizeBytes(1073741824)
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .serverName("testsvr")
 *             .sku(SkuArgs.builder()
 *                 .name("S2")
 *                 .tier("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a database with specified backup storage redundancy.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var database = new AzureNative.Sql.Database("database", new()
 *     {
 *         DatabaseName = "testdb",
 *         Location = "southeastasia",
 *         RequestedBackupStorageRedundancy = AzureNative.Sql.BackupStorageRedundancy.Zone,
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         ServerName = "testsvr",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabase(ctx, "database", &sql.DatabaseArgs{
 * 			DatabaseName:                     pulumi.String("testdb"),
 * 			Location:                         pulumi.String("southeastasia"),
 * 			RequestedBackupStorageRedundancy: pulumi.String(sql.BackupStorageRedundancyZone),
 * 			ResourceGroupName:                pulumi.String("Default-SQL-SouthEastAsia"),
 * 			ServerName:                       pulumi.String("testsvr"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.Database;
 * import com.pulumi.azurenative.sql.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var database = new Database("database", DatabaseArgs.builder()
 *             .databaseName("testdb")
 *             .location("southeastasia")
 *             .requestedBackupStorageRedundancy("Zone")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .serverName("testsvr")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:Database testdb /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}
 * ```
 */
public class Database internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.Database,
) : KotlinCustomResource(javaResource, DatabaseMapper) {
    /**
     * Time in minutes after which database is automatically paused. A value of -1 means that automatic pause is disabled
     */
    public val autoPauseDelay: Output<Int>?
        get() = javaResource.autoPauseDelay().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Collation of the metadata catalog.
     */
    public val catalogCollation: Output<String>?
        get() = javaResource.catalogCollation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The collation of the database.
     */
    public val collation: Output<String>?
        get() = javaResource.collation().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The creation date of the database (ISO8601 format).
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * The storage account type used to store backups for this database.
     */
    public val currentBackupStorageRedundancy: Output<String>
        get() = javaResource.currentBackupStorageRedundancy().applyValue({ args0 -> args0 })

    /**
     * The current service level objective name of the database.
     */
    public val currentServiceObjectiveName: Output<String>
        get() = javaResource.currentServiceObjectiveName().applyValue({ args0 -> args0 })

    /**
     * The name and tier of the SKU.
     */
    public val currentSku: Output<SkuResponse>
        get() = javaResource.currentSku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * The ID of the database.
     */
    public val databaseId: Output<String>
        get() = javaResource.databaseId().applyValue({ args0 -> args0 })

    /**
     * The default secondary region for this database.
     */
    public val defaultSecondaryLocation: Output<String>
        get() = javaResource.defaultSecondaryLocation().applyValue({ args0 -> args0 })

    /**
     * This records the earliest start date and time that restore is available for this database (ISO8601 format).
     */
    public val earliestRestoreDate: Output<String>
        get() = javaResource.earliestRestoreDate().applyValue({ args0 -> args0 })

    /**
     * The resource identifier of the elastic pool containing this database.
     */
    public val elasticPoolId: Output<String>?
        get() = javaResource.elasticPoolId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Failover Group resource identifier that this database belongs to.
     */
    public val failoverGroupId: Output<String>
        get() = javaResource.failoverGroupId().applyValue({ args0 -> args0 })

    /**
     * The Client id used for cross tenant per database CMK scenario
     */
    public val federatedClientId: Output<String>?
        get() = javaResource.federatedClientId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of secondary replicas associated with the database that are used to provide high availability. Not applicable to a Hyperscale database within an elastic pool.
     */
    public val highAvailabilityReplicaCount: Output<Int>?
        get() = javaResource.highAvailabilityReplicaCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Azure Active Directory identity of the database.
     */
    public val identity: Output<DatabaseIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    databaseIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Infra encryption is enabled for this database.
     */
    public val isInfraEncryptionEnabled: Output<Boolean>
        get() = javaResource.isInfraEncryptionEnabled().applyValue({ args0 -> args0 })

    /**
     * Whether or not this database is a ledger database, which means all tables in the database are ledger tables. Note: the value of this property cannot be changed after the database has been created.
     */
    public val isLedgerOn: Output<Boolean>?
        get() = javaResource.isLedgerOn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Kind of database. This is metadata used for the Azure portal experience.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The license type to apply for this database. `LicenseIncluded` if you need a license, or `BasePrice` if you have a license and are eligible for the Azure Hybrid Benefit.
     */
    public val licenseType: Output<String>?
        get() = javaResource.licenseType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Maintenance configuration id assigned to the database. This configuration defines the period when the maintenance updates will occur.
     */
    public val maintenanceConfigurationId: Output<String>?
        get() = javaResource.maintenanceConfigurationId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource that manages the database.
     */
    public val managedBy: Output<String>
        get() = javaResource.managedBy().applyValue({ args0 -> args0 })

    /**
     * The max log size for this database.
     */
    public val maxLogSizeBytes: Output<Double>
        get() = javaResource.maxLogSizeBytes().applyValue({ args0 -> args0 })

    /**
     * The max size of the database expressed in bytes.
     */
    public val maxSizeBytes: Output<Double>?
        get() = javaResource.maxSizeBytes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Minimal capacity that database will always have allocated, if not paused
     */
    public val minCapacity: Output<Double>?
        get() = javaResource.minCapacity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The date when database was paused by user configuration or action(ISO8601 format). Null if the database is ready.
     */
    public val pausedDate: Output<String>
        get() = javaResource.pausedDate().applyValue({ args0 -> args0 })

    /**
     * The state of read-only routing. If enabled, connections that have application intent set to readonly in their connection string may be routed to a readonly secondary replica in the same region. Not applicable to a Hyperscale database within an elastic pool.
     */
    public val readScale: Output<String>?
        get() = javaResource.readScale().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The storage account type to be used to store backups for this database.
     */
    public val requestedBackupStorageRedundancy: Output<String>?
        get() = javaResource.requestedBackupStorageRedundancy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The requested service level objective name of the database.
     */
    public val requestedServiceObjectiveName: Output<String>
        get() = javaResource.requestedServiceObjectiveName().applyValue({ args0 -> args0 })

    /**
     * The date when database was resumed by user action or database login (ISO8601 format). Null if the database is paused.
     */
    public val resumedDate: Output<String>
        get() = javaResource.resumedDate().applyValue({ args0 -> args0 })

    /**
     * The secondary type of the database if it is a secondary.  Valid values are Geo and Named.
     */
    public val secondaryType: Output<String>?
        get() = javaResource.secondaryType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The database SKU.
     * The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:
     * ```azurecli
     * az sql db list-editions -l <location> -o table
     * ````
     * ```powershell
     * Get-AzSqlServerServiceObjective -Location <location>
     * ````
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The status of the database.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Whether or not this database is zone redundant, which means the replicas of this database will be spread across multiple availability zones.
     */
    public val zoneRedundant: Output<Boolean>?
        get() = javaResource.zoneRedundant().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object DatabaseMapper : ResourceMapper<Database> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.Database::class == javaResource::class

    override fun map(javaResource: Resource): Database = Database(
        javaResource as
            com.pulumi.azurenative.sql.Database,
    )
}

/**
 * @see [Database].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Database].
 */
public suspend fun database(name: String, block: suspend DatabaseResourceBuilder.() -> Unit): Database {
    val builder = DatabaseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Database].
 * @param name The _unique_ name of the resulting resource.
 */
public fun database(name: String): Database {
    val builder = DatabaseResourceBuilder()
    builder.name(name)
    return builder.build()
}
