@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DisasterRecoveryConfiguration].
 */
@PulumiTagMarker
public class DisasterRecoveryConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DisasterRecoveryConfigurationArgs = DisasterRecoveryConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DisasterRecoveryConfigurationArgsBuilder.() -> Unit) {
        val builder = DisasterRecoveryConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DisasterRecoveryConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.sql.DisasterRecoveryConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DisasterRecoveryConfiguration(builtJavaResource)
    }
}

/**
 * Represents a disaster recovery configuration.
 * Azure REST API version: 2014-04-01. Prior API version in Azure Native 1.x: 2014-04-01.
 * ## Example Usage
 * ### Update a disaster recovery configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disasterRecoveryConfiguration = new AzureNative.Sql.DisasterRecoveryConfiguration("disasterRecoveryConfiguration", new()
 *     {
 *         DisasterRecoveryConfigurationName = "Default",
 *         ResourceGroupName = "sqlcrudtest-4799",
 *         ServerName = "sqlcrudtest-5961",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDisasterRecoveryConfiguration(ctx, "disasterRecoveryConfiguration", &sql.DisasterRecoveryConfigurationArgs{
 * 			DisasterRecoveryConfigurationName: pulumi.String("Default"),
 * 			ResourceGroupName:                 pulumi.String("sqlcrudtest-4799"),
 * 			ServerName:                        pulumi.String("sqlcrudtest-5961"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DisasterRecoveryConfiguration;
 * import com.pulumi.azurenative.sql.DisasterRecoveryConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disasterRecoveryConfiguration = new DisasterRecoveryConfiguration("disasterRecoveryConfiguration", DisasterRecoveryConfigurationArgs.builder()
 *             .disasterRecoveryConfigurationName("Default")
 *             .resourceGroupName("sqlcrudtest-4799")
 *             .serverName("sqlcrudtest-5961")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:DisasterRecoveryConfiguration Default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/disasterRecoveryConfiguration/{disasterRecoveryConfigurationName}
 * ```
 */
public class DisasterRecoveryConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.DisasterRecoveryConfiguration,
) : KotlinCustomResource(javaResource, DisasterRecoveryConfigurationMapper) {
    /**
     * Whether or not failover can be done automatically.
     */
    public val autoFailover: Output<String>
        get() = javaResource.autoFailover().applyValue({ args0 -> args0 })

    /**
     * How aggressive the automatic failover should be.
     */
    public val failoverPolicy: Output<String>
        get() = javaResource.failoverPolicy().applyValue({ args0 -> args0 })

    /**
     * Location of the server that contains this disaster recovery configuration.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Logical name of the server.
     */
    public val logicalServerName: Output<String>
        get() = javaResource.logicalServerName().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Logical name of the partner server.
     */
    public val partnerLogicalServerName: Output<String>
        get() = javaResource.partnerLogicalServerName().applyValue({ args0 -> args0 })

    /**
     * Id of the partner server.
     */
    public val partnerServerId: Output<String>
        get() = javaResource.partnerServerId().applyValue({ args0 -> args0 })

    /**
     * The role of the current server in the disaster recovery configuration.
     */
    public val role: Output<String>
        get() = javaResource.role().applyValue({ args0 -> args0 })

    /**
     * The status of the disaster recovery configuration.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DisasterRecoveryConfigurationMapper : ResourceMapper<DisasterRecoveryConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.DisasterRecoveryConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): DisasterRecoveryConfiguration =
        DisasterRecoveryConfiguration(
            javaResource as
                com.pulumi.azurenative.sql.DisasterRecoveryConfiguration,
        )
}

/**
 * @see [DisasterRecoveryConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DisasterRecoveryConfiguration].
 */
public suspend fun disasterRecoveryConfiguration(
    name: String,
    block: suspend DisasterRecoveryConfigurationResourceBuilder.() -> Unit,
): DisasterRecoveryConfiguration {
    val builder = DisasterRecoveryConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DisasterRecoveryConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun disasterRecoveryConfiguration(name: String): DisasterRecoveryConfiguration {
    val builder = DisasterRecoveryConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
