@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.kotlin.outputs.InstanceFailoverGroupReadOnlyEndpointResponse
import com.pulumi.azurenative.sql.kotlin.outputs.InstanceFailoverGroupReadWriteEndpointResponse
import com.pulumi.azurenative.sql.kotlin.outputs.ManagedInstancePairInfoResponse
import com.pulumi.azurenative.sql.kotlin.outputs.PartnerRegionInfoResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.sql.kotlin.outputs.InstanceFailoverGroupReadOnlyEndpointResponse.Companion.toKotlin as instanceFailoverGroupReadOnlyEndpointResponseToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.InstanceFailoverGroupReadWriteEndpointResponse.Companion.toKotlin as instanceFailoverGroupReadWriteEndpointResponseToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.ManagedInstancePairInfoResponse.Companion.toKotlin as managedInstancePairInfoResponseToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.PartnerRegionInfoResponse.Companion.toKotlin as partnerRegionInfoResponseToKotlin

/**
 * Builder for [InstanceFailoverGroup].
 */
@PulumiTagMarker
public class InstanceFailoverGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceFailoverGroupArgs = InstanceFailoverGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceFailoverGroupArgsBuilder.() -> Unit) {
        val builder = InstanceFailoverGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): InstanceFailoverGroup {
        val builtJavaResource =
            com.pulumi.azurenative.sql.InstanceFailoverGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return InstanceFailoverGroup(builtJavaResource)
    }
}

/**
 * An instance failover group.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create failover group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var instanceFailoverGroup = new AzureNative.Sql.InstanceFailoverGroup("instanceFailoverGroup", new()
 *     {
 *         FailoverGroupName = "failover-group-test-3",
 *         LocationName = "Japan East",
 *         ManagedInstancePairs = new[]
 *         {
 *             new AzureNative.Sql.Inputs.ManagedInstancePairInfoArgs
 *             {
 *                 PartnerManagedInstanceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/failover-group-secondary-mngdInstance",
 *                 PrimaryManagedInstanceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/failover-group-primary-mngdInstance",
 *             },
 *         },
 *         PartnerRegions = new[]
 *         {
 *             new AzureNative.Sql.Inputs.PartnerRegionInfoArgs
 *             {
 *                 Location = "Japan West",
 *             },
 *         },
 *         ReadOnlyEndpoint = new AzureNative.Sql.Inputs.InstanceFailoverGroupReadOnlyEndpointArgs
 *         {
 *             FailoverPolicy = AzureNative.Sql.ReadOnlyEndpointFailoverPolicy.Disabled,
 *         },
 *         ReadWriteEndpoint = new AzureNative.Sql.Inputs.InstanceFailoverGroupReadWriteEndpointArgs
 *         {
 *             FailoverPolicy = AzureNative.Sql.ReadWriteEndpointFailoverPolicy.Automatic,
 *             FailoverWithDataLossGracePeriodMinutes = 480,
 *         },
 *         ResourceGroupName = "Default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewInstanceFailoverGroup(ctx, "instanceFailoverGroup", &sql.InstanceFailoverGroupArgs{
 * 			FailoverGroupName: pulumi.String("failover-group-test-3"),
 * 			LocationName:      pulumi.String("Japan East"),
 * 			ManagedInstancePairs: sql.ManagedInstancePairInfoArray{
 * 				&sql.ManagedInstancePairInfoArgs{
 * 					PartnerManagedInstanceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/failover-group-secondary-mngdInstance"),
 * 					PrimaryManagedInstanceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/failover-group-primary-mngdInstance"),
 * 				},
 * 			},
 * 			PartnerRegions: sql.PartnerRegionInfoArray{
 * 				&sql.PartnerRegionInfoArgs{
 * 					Location: pulumi.String("Japan West"),
 * 				},
 * 			},
 * 			ReadOnlyEndpoint: &sql.InstanceFailoverGroupReadOnlyEndpointArgs{
 * 				FailoverPolicy: pulumi.String(sql.ReadOnlyEndpointFailoverPolicyDisabled),
 * 			},
 * 			ReadWriteEndpoint: &sql.InstanceFailoverGroupReadWriteEndpointArgs{
 * 				FailoverPolicy:                         pulumi.String(sql.ReadWriteEndpointFailoverPolicyAutomatic),
 * 				FailoverWithDataLossGracePeriodMinutes: pulumi.Int(480),
 * 			},
 * 			ResourceGroupName: pulumi.String("Default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.InstanceFailoverGroup;
 * import com.pulumi.azurenative.sql.InstanceFailoverGroupArgs;
 * import com.pulumi.azurenative.sql.inputs.ManagedInstancePairInfoArgs;
 * import com.pulumi.azurenative.sql.inputs.PartnerRegionInfoArgs;
 * import com.pulumi.azurenative.sql.inputs.InstanceFailoverGroupReadOnlyEndpointArgs;
 * import com.pulumi.azurenative.sql.inputs.InstanceFailoverGroupReadWriteEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var instanceFailoverGroup = new InstanceFailoverGroup("instanceFailoverGroup", InstanceFailoverGroupArgs.builder()
 *             .failoverGroupName("failover-group-test-3")
 *             .locationName("Japan East")
 *             .managedInstancePairs(ManagedInstancePairInfoArgs.builder()
 *                 .partnerManagedInstanceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/failover-group-secondary-mngdInstance")
 *                 .primaryManagedInstanceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/failover-group-primary-mngdInstance")
 *                 .build())
 *             .partnerRegions(PartnerRegionInfoArgs.builder()
 *                 .location("Japan West")
 *                 .build())
 *             .readOnlyEndpoint(InstanceFailoverGroupReadOnlyEndpointArgs.builder()
 *                 .failoverPolicy("Disabled")
 *                 .build())
 *             .readWriteEndpoint(InstanceFailoverGroupReadWriteEndpointArgs.builder()
 *                 .failoverPolicy("Automatic")
 *                 .failoverWithDataLossGracePeriodMinutes(480)
 *                 .build())
 *             .resourceGroupName("Default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:InstanceFailoverGroup failover-group-test-3 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}
 * ```
 */
public class InstanceFailoverGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.InstanceFailoverGroup,
) : KotlinCustomResource(javaResource, InstanceFailoverGroupMapper) {
    /**
     * List of managed instance pairs in the failover group.
     */
    public val managedInstancePairs: Output<List<ManagedInstancePairInfoResponse>>
        get() = javaResource.managedInstancePairs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> managedInstancePairInfoResponseToKotlin(args0) })
            })
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Partner region information for the failover group.
     */
    public val partnerRegions: Output<List<PartnerRegionInfoResponse>>
        get() = javaResource.partnerRegions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> partnerRegionInfoResponseToKotlin(args0) })
            })
        })

    /**
     * Read-only endpoint of the failover group instance.
     */
    public val readOnlyEndpoint: Output<InstanceFailoverGroupReadOnlyEndpointResponse>?
        get() = javaResource.readOnlyEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    instanceFailoverGroupReadOnlyEndpointResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Read-write endpoint of the failover group instance.
     */
    public val readWriteEndpoint: Output<InstanceFailoverGroupReadWriteEndpointResponse>
        get() = javaResource.readWriteEndpoint().applyValue({ args0 ->
            args0.let({ args0 ->
                instanceFailoverGroupReadWriteEndpointResponseToKotlin(args0)
            })
        })

    /**
     * Local replication role of the failover group instance.
     */
    public val replicationRole: Output<String>
        get() = javaResource.replicationRole().applyValue({ args0 -> args0 })

    /**
     * Replication state of the failover group instance.
     */
    public val replicationState: Output<String>
        get() = javaResource.replicationState().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object InstanceFailoverGroupMapper : ResourceMapper<InstanceFailoverGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.InstanceFailoverGroup::class == javaResource::class

    override fun map(javaResource: Resource): InstanceFailoverGroup =
        InstanceFailoverGroup(javaResource as com.pulumi.azurenative.sql.InstanceFailoverGroup)
}

/**
 * @see [InstanceFailoverGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InstanceFailoverGroup].
 */
public suspend fun instanceFailoverGroup(
    name: String,
    block: suspend InstanceFailoverGroupResourceBuilder.() -> Unit,
): InstanceFailoverGroup {
    val builder = InstanceFailoverGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InstanceFailoverGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instanceFailoverGroup(name: String): InstanceFailoverGroup {
    val builder = InstanceFailoverGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
