@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.kotlin.outputs.JobScheduleResponse
import com.pulumi.azurenative.sql.kotlin.outputs.JobScheduleResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Job].
 */
@PulumiTagMarker
public class JobResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobArgs = JobArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobArgsBuilder.() -> Unit) {
        val builder = JobArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Job {
        val builtJavaResource = com.pulumi.azurenative.sql.Job(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Job(builtJavaResource)
    }
}

/**
 * A job.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create a job with all properties specified
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.Sql.Job("job", new()
 *     {
 *         Description = "my favourite job",
 *         JobAgentName = "agent1",
 *         JobName = "job1",
 *         ResourceGroupName = "group1",
 *         Schedule = new AzureNative.Sql.Inputs.JobScheduleArgs
 *         {
 *             Enabled = true,
 *             EndTime = "2015-09-24T23:59:59Z",
 *             Interval = "PT5M",
 *             StartTime = "2015-09-24T18:30:01Z",
 *             Type = AzureNative.Sql.JobScheduleType.Recurring,
 *         },
 *         ServerName = "server1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewJob(ctx, "job", &sql.JobArgs{
 * 			Description:       pulumi.String("my favourite job"),
 * 			JobAgentName:      pulumi.String("agent1"),
 * 			JobName:           pulumi.String("job1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			Schedule: &sql.JobScheduleArgs{
 * 				Enabled:   pulumi.Bool(true),
 * 				EndTime:   pulumi.String("2015-09-24T23:59:59Z"),
 * 				Interval:  pulumi.String("PT5M"),
 * 				StartTime: pulumi.String("2015-09-24T18:30:01Z"),
 * 				Type:      sql.JobScheduleTypeRecurring,
 * 			},
 * 			ServerName: pulumi.String("server1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.Job;
 * import com.pulumi.azurenative.sql.JobArgs;
 * import com.pulumi.azurenative.sql.inputs.JobScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .description("my favourite job")
 *             .jobAgentName("agent1")
 *             .jobName("job1")
 *             .resourceGroupName("group1")
 *             .schedule(JobScheduleArgs.builder()
 *                 .enabled(true)
 *                 .endTime("2015-09-24T23:59:59Z")
 *                 .interval("PT5M")
 *                 .startTime("2015-09-24T18:30:01Z")
 *                 .type("Recurring")
 *                 .build())
 *             .serverName("server1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a job with default properties
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.Sql.Job("job", new()
 *     {
 *         JobAgentName = "agent1",
 *         JobName = "job1",
 *         ResourceGroupName = "group1",
 *         ServerName = "server1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewJob(ctx, "job", &sql.JobArgs{
 * 			JobAgentName:      pulumi.String("agent1"),
 * 			JobName:           pulumi.String("job1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			ServerName:        pulumi.String("server1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.Job;
 * import com.pulumi.azurenative.sql.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .jobAgentName("agent1")
 *             .jobName("job1")
 *             .resourceGroupName("group1")
 *             .serverName("server1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:Job job1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}
 * ```
 */
public class Job internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.Job,
) : KotlinCustomResource(javaResource, JobMapper) {
    /**
     * User-defined description of the job.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Schedule properties of the job.
     */
    public val schedule: Output<JobScheduleResponse>?
        get() = javaResource.schedule().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The job version number.
     */
    public val version: Output<Int>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object JobMapper : ResourceMapper<Job> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.Job::class == javaResource::class

    override fun map(javaResource: Resource): Job = Job(
        javaResource as
            com.pulumi.azurenative.sql.Job,
    )
}

/**
 * @see [Job].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Job].
 */
public suspend fun job(name: String, block: suspend JobResourceBuilder.() -> Unit): Job {
    val builder = JobResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Job].
 * @param name The _unique_ name of the resulting resource.
 */
public fun job(name: String): Job {
    val builder = JobResourceBuilder()
    builder.name(name)
    return builder.build()
}
