@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.sql.kotlin.outputs.SkuResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [JobAgent].
 */
@PulumiTagMarker
public class JobAgentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobAgentArgs = JobAgentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobAgentArgsBuilder.() -> Unit) {
        val builder = JobAgentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): JobAgent {
        val builtJavaResource = com.pulumi.azurenative.sql.JobAgent(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return JobAgent(builtJavaResource)
    }
}

/**
 * An Azure SQL job agent.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create or update a job agent
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jobAgent = new AzureNative.Sql.JobAgent("jobAgent", new()
 *     {
 *         DatabaseId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/databases/db1",
 *         JobAgentName = "agent1",
 *         Location = "southeastasia",
 *         ResourceGroupName = "group1",
 *         ServerName = "server1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewJobAgent(ctx, "jobAgent", &sql.JobAgentArgs{
 * 			DatabaseId:        pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/databases/db1"),
 * 			JobAgentName:      pulumi.String("agent1"),
 * 			Location:          pulumi.String("southeastasia"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			ServerName:        pulumi.String("server1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.JobAgent;
 * import com.pulumi.azurenative.sql.JobAgentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jobAgent = new JobAgent("jobAgent", JobAgentArgs.builder()
 *             .databaseId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/databases/db1")
 *             .jobAgentName("agent1")
 *             .location("southeastasia")
 *             .resourceGroupName("group1")
 *             .serverName("server1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:JobAgent agent1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}
 * ```
 */
public class JobAgent internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.JobAgent,
) : KotlinCustomResource(javaResource, JobAgentMapper) {
    /**
     * Resource ID of the database to store job metadata in.
     */
    public val databaseId: Output<String>
        get() = javaResource.databaseId().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name and tier of the SKU.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The state of the job agent.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object JobAgentMapper : ResourceMapper<JobAgent> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.JobAgent::class == javaResource::class

    override fun map(javaResource: Resource): JobAgent = JobAgent(
        javaResource as
            com.pulumi.azurenative.sql.JobAgent,
    )
}

/**
 * @see [JobAgent].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [JobAgent].
 */
public suspend fun jobAgent(name: String, block: suspend JobAgentResourceBuilder.() -> Unit): JobAgent {
    val builder = JobAgentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [JobAgent].
 * @param name The _unique_ name of the resulting resource.
 */
public fun jobAgent(name: String): JobAgent {
    val builder = JobAgentResourceBuilder()
    builder.name(name)
    return builder.build()
}
