@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.JobCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A stored credential that can be used by a job to connect to target databases.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create or update a credential
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jobCredential = new AzureNative.Sql.JobCredential("jobCredential", new()
 *     {
 *         CredentialName = "cred1",
 *         JobAgentName = "agent1",
 *         Password = "<password>",
 *         ResourceGroupName = "group1",
 *         ServerName = "server1",
 *         Username = "myuser",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewJobCredential(ctx, "jobCredential", &sql.JobCredentialArgs{
 * 			CredentialName:    pulumi.String("cred1"),
 * 			JobAgentName:      pulumi.String("agent1"),
 * 			Password:          pulumi.String("<password>"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			ServerName:        pulumi.String("server1"),
 * 			Username:          pulumi.String("myuser"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.JobCredential;
 * import com.pulumi.azurenative.sql.JobCredentialArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jobCredential = new JobCredential("jobCredential", JobCredentialArgs.builder()
 *             .credentialName("cred1")
 *             .jobAgentName("agent1")
 *             .password("<password>")
 *             .resourceGroupName("group1")
 *             .serverName("server1")
 *             .username("myuser")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:JobCredential cred1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/credentials/{credentialName}
 * ```
 * @property credentialName The name of the credential.
 * @property jobAgentName The name of the job agent.
 * @property password The credential password.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property username The credential user name.
 */
public data class JobCredentialArgs(
    public val credentialName: Output<String>? = null,
    public val jobAgentName: Output<String>? = null,
    public val password: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.JobCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.JobCredentialArgs =
        com.pulumi.azurenative.sql.JobCredentialArgs.builder()
            .credentialName(credentialName?.applyValue({ args0 -> args0 }))
            .jobAgentName(jobAgentName?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobCredentialArgs].
 */
@PulumiTagMarker
public class JobCredentialArgsBuilder internal constructor() {
    private var credentialName: Output<String>? = null

    private var jobAgentName: Output<String>? = null

    private var password: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The name of the credential.
     */
    @JvmName("rcyqswximyvjkiiy")
    public suspend fun credentialName(`value`: Output<String>) {
        this.credentialName = value
    }

    /**
     * @param value The name of the job agent.
     */
    @JvmName("ojhetldskofftoxi")
    public suspend fun jobAgentName(`value`: Output<String>) {
        this.jobAgentName = value
    }

    /**
     * @param value The credential password.
     */
    @JvmName("hmxeylfgcwcsecxr")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("egfuwwaemedbbqiv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("koxhcsmmjdinoygy")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The credential user name.
     */
    @JvmName("vlyplidoqhvjiuyw")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The name of the credential.
     */
    @JvmName("ulkomewjkjaqxucn")
    public suspend fun credentialName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialName = mapped
    }

    /**
     * @param value The name of the job agent.
     */
    @JvmName("jcsgugdjslablemt")
    public suspend fun jobAgentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobAgentName = mapped
    }

    /**
     * @param value The credential password.
     */
    @JvmName("tdyxxhyvjeybdnxk")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("xaejbjbspbgiaptm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("rjnrdeuhsxelpral")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The credential user name.
     */
    @JvmName("pavqnkhkumreravb")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): JobCredentialArgs = JobCredentialArgs(
        credentialName = credentialName,
        jobAgentName = jobAgentName,
        password = password,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        username = username,
    )
}
