@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [JobPrivateEndpoint].
 */
@PulumiTagMarker
public class JobPrivateEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobPrivateEndpointArgs = JobPrivateEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobPrivateEndpointArgsBuilder.() -> Unit) {
        val builder = JobPrivateEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): JobPrivateEndpoint {
        val builtJavaResource = com.pulumi.azurenative.sql.JobPrivateEndpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return JobPrivateEndpoint(builtJavaResource)
    }
}

/**
 * A job agent private endpoint.
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-08-01-preview.
 * ## Example Usage
 * ### Create a private endpoint.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jobPrivateEndpoint = new AzureNative.Sql.JobPrivateEndpoint("jobPrivateEndpoint", new()
 *     {
 *         JobAgentName = "agent1",
 *         PrivateEndpointName = "endpoint1",
 *         ResourceGroupName = "group1",
 *         ServerName = "server1",
 *         TargetServerAzureResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/targetserver1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewJobPrivateEndpoint(ctx, "jobPrivateEndpoint", &sql.JobPrivateEndpointArgs{
 * 			JobAgentName:                pulumi.String("agent1"),
 * 			PrivateEndpointName:         pulumi.String("endpoint1"),
 * 			ResourceGroupName:           pulumi.String("group1"),
 * 			ServerName:                  pulumi.String("server1"),
 * 			TargetServerAzureResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/targetserver1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.JobPrivateEndpoint;
 * import com.pulumi.azurenative.sql.JobPrivateEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jobPrivateEndpoint = new JobPrivateEndpoint("jobPrivateEndpoint", JobPrivateEndpointArgs.builder()
 *             .jobAgentName("agent1")
 *             .privateEndpointName("endpoint1")
 *             .resourceGroupName("group1")
 *             .serverName("server1")
 *             .targetServerAzureResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/targetserver1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:JobPrivateEndpoint endpoint1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/privateEndpoints/{privateEndpointName}
 * ```
 */
public class JobPrivateEndpoint internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.JobPrivateEndpoint,
) : KotlinCustomResource(javaResource, JobPrivateEndpointMapper) {
    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Private endpoint id of the private endpoint.
     */
    public val privateEndpointId: Output<String>
        get() = javaResource.privateEndpointId().applyValue({ args0 -> args0 })

    /**
     * ARM resource id of the server the private endpoint will target.
     */
    public val targetServerAzureResourceId: Output<String>
        get() = javaResource.targetServerAzureResourceId().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object JobPrivateEndpointMapper : ResourceMapper<JobPrivateEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.JobPrivateEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): JobPrivateEndpoint = JobPrivateEndpoint(
        javaResource as
            com.pulumi.azurenative.sql.JobPrivateEndpoint,
    )
}

/**
 * @see [JobPrivateEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [JobPrivateEndpoint].
 */
public suspend fun jobPrivateEndpoint(
    name: String,
    block: suspend JobPrivateEndpointResourceBuilder.() -> Unit,
): JobPrivateEndpoint {
    val builder = JobPrivateEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [JobPrivateEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun jobPrivateEndpoint(name: String): JobPrivateEndpoint {
    val builder = JobPrivateEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
