@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.kotlin.outputs.DatabaseVulnerabilityAssessmentRuleBaselineItemResponse
import com.pulumi.azurenative.sql.kotlin.outputs.DatabaseVulnerabilityAssessmentRuleBaselineItemResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ManagedDatabaseVulnerabilityAssessmentRuleBaseline].
 */
@PulumiTagMarker
public class ManagedDatabaseVulnerabilityAssessmentRuleBaselineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs =
        ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgsBuilder.() -> Unit) {
        val builder = ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagedDatabaseVulnerabilityAssessmentRuleBaseline {
        val builtJavaResource =
            com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessmentRuleBaseline(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )

        return ManagedDatabaseVulnerabilityAssessmentRuleBaseline(builtJavaResource)
    }
}

/**
 * A database vulnerability assessment rule baseline.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Creates or updates a database's vulnerability assessment rule baseline.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedDatabaseVulnerabilityAssessmentRuleBaseline = new AzureNative.Sql.ManagedDatabaseVulnerabilityAssessmentRuleBaseline("managedDatabaseVulnerabilityAssessmentRuleBaseline", new()
 *     {
 *         BaselineName = "default",
 *         BaselineResults = new[]
 *         {
 *             new AzureNative.Sql.Inputs.DatabaseVulnerabilityAssessmentRuleBaselineItemArgs
 *             {
 *                 Result = new[]
 *                 {
 *                     "userA",
 *                     "SELECT",
 *                 },
 *             },
 *             new AzureNative.Sql.Inputs.DatabaseVulnerabilityAssessmentRuleBaselineItemArgs
 *             {
 *                 Result = new[]
 *                 {
 *                     "userB",
 *                     "SELECT",
 *                 },
 *             },
 *             new AzureNative.Sql.Inputs.DatabaseVulnerabilityAssessmentRuleBaselineItemArgs
 *             {
 *                 Result = new[]
 *                 {
 *                     "userC",
 *                     "SELECT",
 *                     "tableId_4",
 *                 },
 *             },
 *         },
 *         DatabaseName = "testdb",
 *         ManagedInstanceName = "vulnerabilityaseessmenttest-6440",
 *         ResourceGroupName = "vulnerabilityaseessmenttest-4799",
 *         RuleId = "VA1001",
 *         VulnerabilityAssessmentName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedDatabaseVulnerabilityAssessmentRuleBaseline(ctx, "managedDatabaseVulnerabilityAssessmentRuleBaseline", &sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs{
 * 			BaselineName: pulumi.String("default"),
 * 			BaselineResults: sql.DatabaseVulnerabilityAssessmentRuleBaselineItemArray{
 * 				&sql.DatabaseVulnerabilityAssessmentRuleBaselineItemArgs{
 * 					Result: pulumi.StringArray{
 * 						pulumi.String("userA"),
 * 						pulumi.String("SELECT"),
 * 					},
 * 				},
 * 				&sql.DatabaseVulnerabilityAssessmentRuleBaselineItemArgs{
 * 					Result: pulumi.StringArray{
 * 						pulumi.String("userB"),
 * 						pulumi.String("SELECT"),
 * 					},
 * 				},
 * 				&sql.DatabaseVulnerabilityAssessmentRuleBaselineItemArgs{
 * 					Result: pulumi.StringArray{
 * 						pulumi.String("userC"),
 * 						pulumi.String("SELECT"),
 * 						pulumi.String("tableId_4"),
 * 					},
 * 				},
 * 			},
 * 			DatabaseName:                pulumi.String("testdb"),
 * 			ManagedInstanceName:         pulumi.String("vulnerabilityaseessmenttest-6440"),
 * 			ResourceGroupName:           pulumi.String("vulnerabilityaseessmenttest-4799"),
 * 			RuleId:                      pulumi.String("VA1001"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessmentRuleBaseline;
 * import com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs;
 * import com.pulumi.azurenative.sql.inputs.DatabaseVulnerabilityAssessmentRuleBaselineItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedDatabaseVulnerabilityAssessmentRuleBaseline = new ManagedDatabaseVulnerabilityAssessmentRuleBaseline("managedDatabaseVulnerabilityAssessmentRuleBaseline", ManagedDatabaseVulnerabilityAssessmentRuleBaselineArgs.builder()
 *             .baselineName("default")
 *             .baselineResults(
 *                 DatabaseVulnerabilityAssessmentRuleBaselineItemArgs.builder()
 *                     .result(
 *                         "userA",
 *                         "SELECT")
 *                     .build(),
 *                 DatabaseVulnerabilityAssessmentRuleBaselineItemArgs.builder()
 *                     .result(
 *                         "userB",
 *                         "SELECT")
 *                     .build(),
 *                 DatabaseVulnerabilityAssessmentRuleBaselineItemArgs.builder()
 *                     .result(
 *                         "userC",
 *                         "SELECT",
 *                         "tableId_4")
 *                     .build())
 *             .databaseName("testdb")
 *             .managedInstanceName("vulnerabilityaseessmenttest-6440")
 *             .resourceGroupName("vulnerabilityaseessmenttest-4799")
 *             .ruleId("VA1001")
 *             .vulnerabilityAssessmentName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ManagedDatabaseVulnerabilityAssessmentRuleBaseline default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}
 * ```
 */
public class ManagedDatabaseVulnerabilityAssessmentRuleBaseline internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessmentRuleBaseline,
) : KotlinCustomResource(javaResource, ManagedDatabaseVulnerabilityAssessmentRuleBaselineMapper) {
    /**
     * The rule baseline result
     */
    public val baselineResults: Output<List<DatabaseVulnerabilityAssessmentRuleBaselineItemResponse>>
        get() = javaResource.baselineResults().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagedDatabaseVulnerabilityAssessmentRuleBaselineMapper :
    ResourceMapper<ManagedDatabaseVulnerabilityAssessmentRuleBaseline> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessmentRuleBaseline::class == javaResource::class

    override fun map(javaResource: Resource): ManagedDatabaseVulnerabilityAssessmentRuleBaseline =
        ManagedDatabaseVulnerabilityAssessmentRuleBaseline(
            javaResource as
                com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessmentRuleBaseline,
        )
}

/**
 * @see [ManagedDatabaseVulnerabilityAssessmentRuleBaseline].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedDatabaseVulnerabilityAssessmentRuleBaseline].
 */
public suspend fun managedDatabaseVulnerabilityAssessmentRuleBaseline(
    name: String,
    block: suspend ManagedDatabaseVulnerabilityAssessmentRuleBaselineResourceBuilder.() -> Unit,
): ManagedDatabaseVulnerabilityAssessmentRuleBaseline {
    val builder = ManagedDatabaseVulnerabilityAssessmentRuleBaselineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedDatabaseVulnerabilityAssessmentRuleBaseline].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedDatabaseVulnerabilityAssessmentRuleBaseline(name: String): ManagedDatabaseVulnerabilityAssessmentRuleBaseline {
    val builder = ManagedDatabaseVulnerabilityAssessmentRuleBaselineResourceBuilder()
    builder.name(name)
    return builder.build()
}
