@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ManagedInstanceAdministrator].
 */
@PulumiTagMarker
public class ManagedInstanceAdministratorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedInstanceAdministratorArgs = ManagedInstanceAdministratorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedInstanceAdministratorArgsBuilder.() -> Unit) {
        val builder = ManagedInstanceAdministratorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagedInstanceAdministrator {
        val builtJavaResource =
            com.pulumi.azurenative.sql.ManagedInstanceAdministrator(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagedInstanceAdministrator(builtJavaResource)
    }
}

/**
 * An Azure SQL managed instance administrator.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create administrator of managed instance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedInstanceAdministrator = new AzureNative.Sql.ManagedInstanceAdministrator("managedInstanceAdministrator", new()
 *     {
 *         AdministratorName = "ActiveDirectory",
 *         AdministratorType = AzureNative.Sql.ManagedInstanceAdministratorType.ActiveDirectory,
 *         Login = "bob@contoso.com",
 *         ManagedInstanceName = "managedInstance",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         Sid = "44444444-3333-2222-1111-000000000000",
 *         TenantId = "55555555-4444-3333-2222-111111111111",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedInstanceAdministrator(ctx, "managedInstanceAdministrator", &sql.ManagedInstanceAdministratorArgs{
 * 			AdministratorName:   pulumi.String("ActiveDirectory"),
 * 			AdministratorType:   pulumi.String(sql.ManagedInstanceAdministratorTypeActiveDirectory),
 * 			Login:               pulumi.String("bob@contoso.com"),
 * 			ManagedInstanceName: pulumi.String("managedInstance"),
 * 			ResourceGroupName:   pulumi.String("Default-SQL-SouthEastAsia"),
 * 			Sid:                 pulumi.String("44444444-3333-2222-1111-000000000000"),
 * 			TenantId:            pulumi.String("55555555-4444-3333-2222-111111111111"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedInstanceAdministrator;
 * import com.pulumi.azurenative.sql.ManagedInstanceAdministratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedInstanceAdministrator = new ManagedInstanceAdministrator("managedInstanceAdministrator", ManagedInstanceAdministratorArgs.builder()
 *             .administratorName("ActiveDirectory")
 *             .administratorType("ActiveDirectory")
 *             .login("bob@contoso.com")
 *             .managedInstanceName("managedInstance")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .sid("44444444-3333-2222-1111-000000000000")
 *             .tenantId("55555555-4444-3333-2222-111111111111")
 *             .build());
 *     }
 * }
 * ```
 * ### Update administrator of managed instance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedInstanceAdministrator = new AzureNative.Sql.ManagedInstanceAdministrator("managedInstanceAdministrator", new()
 *     {
 *         AdministratorName = "ActiveDirectory",
 *         AdministratorType = AzureNative.Sql.ManagedInstanceAdministratorType.ActiveDirectory,
 *         Login = "bob@contoso.com",
 *         ManagedInstanceName = "managedInstance",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         Sid = "44444444-3333-2222-1111-000000000000",
 *         TenantId = "55555555-4444-3333-2222-111111111111",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedInstanceAdministrator(ctx, "managedInstanceAdministrator", &sql.ManagedInstanceAdministratorArgs{
 * 			AdministratorName:   pulumi.String("ActiveDirectory"),
 * 			AdministratorType:   pulumi.String(sql.ManagedInstanceAdministratorTypeActiveDirectory),
 * 			Login:               pulumi.String("bob@contoso.com"),
 * 			ManagedInstanceName: pulumi.String("managedInstance"),
 * 			ResourceGroupName:   pulumi.String("Default-SQL-SouthEastAsia"),
 * 			Sid:                 pulumi.String("44444444-3333-2222-1111-000000000000"),
 * 			TenantId:            pulumi.String("55555555-4444-3333-2222-111111111111"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedInstanceAdministrator;
 * import com.pulumi.azurenative.sql.ManagedInstanceAdministratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedInstanceAdministrator = new ManagedInstanceAdministrator("managedInstanceAdministrator", ManagedInstanceAdministratorArgs.builder()
 *             .administratorName("ActiveDirectory")
 *             .administratorType("ActiveDirectory")
 *             .login("bob@contoso.com")
 *             .managedInstanceName("managedInstance")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .sid("44444444-3333-2222-1111-000000000000")
 *             .tenantId("55555555-4444-3333-2222-111111111111")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ManagedInstanceAdministrator ActiveDirectory /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/administrators/{administratorName}
 * ```
 */
public class ManagedInstanceAdministrator internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.ManagedInstanceAdministrator,
) : KotlinCustomResource(javaResource, ManagedInstanceAdministratorMapper) {
    /**
     * Type of the managed instance administrator.
     */
    public val administratorType: Output<String>
        get() = javaResource.administratorType().applyValue({ args0 -> args0 })

    /**
     * Login name of the managed instance administrator.
     */
    public val login: Output<String>
        get() = javaResource.login().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * SID (object ID) of the managed instance administrator.
     */
    public val sid: Output<String>
        get() = javaResource.sid().applyValue({ args0 -> args0 })

    /**
     * Tenant ID of the managed instance administrator.
     */
    public val tenantId: Output<String>?
        get() = javaResource.tenantId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagedInstanceAdministratorMapper : ResourceMapper<ManagedInstanceAdministrator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.ManagedInstanceAdministrator::class == javaResource::class

    override fun map(javaResource: Resource): ManagedInstanceAdministrator =
        ManagedInstanceAdministrator(
            javaResource as
                com.pulumi.azurenative.sql.ManagedInstanceAdministrator,
        )
}

/**
 * @see [ManagedInstanceAdministrator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedInstanceAdministrator].
 */
public suspend fun managedInstanceAdministrator(
    name: String,
    block: suspend ManagedInstanceAdministratorResourceBuilder.() -> Unit,
): ManagedInstanceAdministrator {
    val builder = ManagedInstanceAdministratorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedInstanceAdministrator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedInstanceAdministrator(name: String): ManagedInstanceAdministrator {
    val builder = ManagedInstanceAdministratorResourceBuilder()
    builder.name(name)
    return builder.build()
}
