@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ManagedInstanceAdministratorArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.ManagedInstanceAdministratorType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An Azure SQL managed instance administrator.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create administrator of managed instance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedInstanceAdministrator = new AzureNative.Sql.ManagedInstanceAdministrator("managedInstanceAdministrator", new()
 *     {
 *         AdministratorName = "ActiveDirectory",
 *         AdministratorType = AzureNative.Sql.ManagedInstanceAdministratorType.ActiveDirectory,
 *         Login = "bob@contoso.com",
 *         ManagedInstanceName = "managedInstance",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         Sid = "44444444-3333-2222-1111-000000000000",
 *         TenantId = "55555555-4444-3333-2222-111111111111",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedInstanceAdministrator(ctx, "managedInstanceAdministrator", &sql.ManagedInstanceAdministratorArgs{
 * 			AdministratorName:   pulumi.String("ActiveDirectory"),
 * 			AdministratorType:   pulumi.String(sql.ManagedInstanceAdministratorTypeActiveDirectory),
 * 			Login:               pulumi.String("bob@contoso.com"),
 * 			ManagedInstanceName: pulumi.String("managedInstance"),
 * 			ResourceGroupName:   pulumi.String("Default-SQL-SouthEastAsia"),
 * 			Sid:                 pulumi.String("44444444-3333-2222-1111-000000000000"),
 * 			TenantId:            pulumi.String("55555555-4444-3333-2222-111111111111"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedInstanceAdministrator;
 * import com.pulumi.azurenative.sql.ManagedInstanceAdministratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedInstanceAdministrator = new ManagedInstanceAdministrator("managedInstanceAdministrator", ManagedInstanceAdministratorArgs.builder()
 *             .administratorName("ActiveDirectory")
 *             .administratorType("ActiveDirectory")
 *             .login("bob@contoso.com")
 *             .managedInstanceName("managedInstance")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .sid("44444444-3333-2222-1111-000000000000")
 *             .tenantId("55555555-4444-3333-2222-111111111111")
 *             .build());
 *     }
 * }
 * ```
 * ### Update administrator of managed instance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedInstanceAdministrator = new AzureNative.Sql.ManagedInstanceAdministrator("managedInstanceAdministrator", new()
 *     {
 *         AdministratorName = "ActiveDirectory",
 *         AdministratorType = AzureNative.Sql.ManagedInstanceAdministratorType.ActiveDirectory,
 *         Login = "bob@contoso.com",
 *         ManagedInstanceName = "managedInstance",
 *         ResourceGroupName = "Default-SQL-SouthEastAsia",
 *         Sid = "44444444-3333-2222-1111-000000000000",
 *         TenantId = "55555555-4444-3333-2222-111111111111",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedInstanceAdministrator(ctx, "managedInstanceAdministrator", &sql.ManagedInstanceAdministratorArgs{
 * 			AdministratorName:   pulumi.String("ActiveDirectory"),
 * 			AdministratorType:   pulumi.String(sql.ManagedInstanceAdministratorTypeActiveDirectory),
 * 			Login:               pulumi.String("bob@contoso.com"),
 * 			ManagedInstanceName: pulumi.String("managedInstance"),
 * 			ResourceGroupName:   pulumi.String("Default-SQL-SouthEastAsia"),
 * 			Sid:                 pulumi.String("44444444-3333-2222-1111-000000000000"),
 * 			TenantId:            pulumi.String("55555555-4444-3333-2222-111111111111"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedInstanceAdministrator;
 * import com.pulumi.azurenative.sql.ManagedInstanceAdministratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedInstanceAdministrator = new ManagedInstanceAdministrator("managedInstanceAdministrator", ManagedInstanceAdministratorArgs.builder()
 *             .administratorName("ActiveDirectory")
 *             .administratorType("ActiveDirectory")
 *             .login("bob@contoso.com")
 *             .managedInstanceName("managedInstance")
 *             .resourceGroupName("Default-SQL-SouthEastAsia")
 *             .sid("44444444-3333-2222-1111-000000000000")
 *             .tenantId("55555555-4444-3333-2222-111111111111")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ManagedInstanceAdministrator ActiveDirectory /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/administrators/{administratorName}
 * ```
 * @property administratorName
 * @property administratorType Type of the managed instance administrator.
 * @property login Login name of the managed instance administrator.
 * @property managedInstanceName The name of the managed instance.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property sid SID (object ID) of the managed instance administrator.
 * @property tenantId Tenant ID of the managed instance administrator.
 */
public data class ManagedInstanceAdministratorArgs(
    public val administratorName: Output<String>? = null,
    public val administratorType: Output<Either<String, ManagedInstanceAdministratorType>>? = null,
    public val login: Output<String>? = null,
    public val managedInstanceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sid: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.ManagedInstanceAdministratorArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.ManagedInstanceAdministratorArgs =
        com.pulumi.azurenative.sql.ManagedInstanceAdministratorArgs.builder()
            .administratorName(administratorName?.applyValue({ args0 -> args0 }))
            .administratorType(
                administratorType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .login(login?.applyValue({ args0 -> args0 }))
            .managedInstanceName(managedInstanceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sid(sid?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedInstanceAdministratorArgs].
 */
@PulumiTagMarker
public class ManagedInstanceAdministratorArgsBuilder internal constructor() {
    private var administratorName: Output<String>? = null

    private var administratorType: Output<Either<String, ManagedInstanceAdministratorType>>? = null

    private var login: Output<String>? = null

    private var managedInstanceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sid: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("busonobctextowgj")
    public suspend fun administratorName(`value`: Output<String>) {
        this.administratorName = value
    }

    /**
     * @param value Type of the managed instance administrator.
     */
    @JvmName("yrmgkadjqxbyatjd")
    public suspend fun administratorType(`value`: Output<Either<String, ManagedInstanceAdministratorType>>) {
        this.administratorType = value
    }

    /**
     * @param value Login name of the managed instance administrator.
     */
    @JvmName("kujaccnjtgelwxvw")
    public suspend fun login(`value`: Output<String>) {
        this.login = value
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("ubbymyegojyjqwgw")
    public suspend fun managedInstanceName(`value`: Output<String>) {
        this.managedInstanceName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("nmymswubtgsisoro")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value SID (object ID) of the managed instance administrator.
     */
    @JvmName("nkgbrqkfurvhyhvr")
    public suspend fun sid(`value`: Output<String>) {
        this.sid = value
    }

    /**
     * @param value Tenant ID of the managed instance administrator.
     */
    @JvmName("xvxjgtomqrrpdurb")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value
     */
    @JvmName("ctbejucpqujsorgy")
    public suspend fun administratorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorName = mapped
    }

    /**
     * @param value Type of the managed instance administrator.
     */
    @JvmName("gtylfxsqyfqngykp")
    public suspend fun administratorType(`value`: Either<String, ManagedInstanceAdministratorType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorType = mapped
    }

    /**
     * @param value Type of the managed instance administrator.
     */
    @JvmName("xngikeueposlefrg")
    public fun administratorType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedInstanceAdministratorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.administratorType = mapped
    }

    /**
     * @param value Type of the managed instance administrator.
     */
    @JvmName("lckmvoqpymievkbg")
    public fun administratorType(`value`: ManagedInstanceAdministratorType) {
        val toBeMapped = Either.ofRight<String, ManagedInstanceAdministratorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.administratorType = mapped
    }

    /**
     * @param value Login name of the managed instance administrator.
     */
    @JvmName("mfnyeaxmeeolesny")
    public suspend fun login(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.login = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("lihgeslantsbdvji")
    public suspend fun managedInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("btysigpbhqkkmeug")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SID (object ID) of the managed instance administrator.
     */
    @JvmName("kkrwsinpxfihwwbc")
    public suspend fun sid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sid = mapped
    }

    /**
     * @param value Tenant ID of the managed instance administrator.
     */
    @JvmName("rdiupcygysguhfpg")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): ManagedInstanceAdministratorArgs = ManagedInstanceAdministratorArgs(
        administratorName = administratorName,
        administratorType = administratorType,
        login = login,
        managedInstanceName = managedInstanceName,
        resourceGroupName = resourceGroupName,
        sid = sid,
        tenantId = tenantId,
    )
}
