@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ManagedInstanceArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.BackupStorageRedundancy
import com.pulumi.azurenative.sql.kotlin.enums.ManagedInstanceLicenseType
import com.pulumi.azurenative.sql.kotlin.enums.ManagedInstanceProxyOverride
import com.pulumi.azurenative.sql.kotlin.enums.ManagedServerCreateMode
import com.pulumi.azurenative.sql.kotlin.inputs.ManagedInstanceExternalAdministratorArgs
import com.pulumi.azurenative.sql.kotlin.inputs.ManagedInstanceExternalAdministratorArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.ResourceIdentityArgs
import com.pulumi.azurenative.sql.kotlin.inputs.ResourceIdentityArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.ServicePrincipalArgs
import com.pulumi.azurenative.sql.kotlin.inputs.ServicePrincipalArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.sql.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure SQL managed instance.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2021-02-01-preview, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create managed instance with all properties
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedInstance = new AzureNative.Sql.ManagedInstance("managedInstance", new()
 *     {
 *         AdministratorLogin = "dummylogin",
 *         AdministratorLoginPassword = "PLACEHOLDER",
 *         Administrators = new AzureNative.Sql.Inputs.ManagedInstanceExternalAdministratorArgs
 *         {
 *             AzureADOnlyAuthentication = true,
 *             Login = "bob@contoso.com",
 *             PrincipalType = AzureNative.Sql.PrincipalType.User,
 *             Sid = "00000011-1111-2222-2222-123456789111",
 *             TenantId = "00000011-1111-2222-2222-123456789111",
 *         },
 *         Collation = "SQL_Latin1_General_CP1_CI_AS",
 *         DnsZonePartner = "/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Sql/managedInstances/testinstance",
 *         InstancePoolId = "/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Sql/instancePools/pool1",
 *         LicenseType = AzureNative.Sql.ManagedInstanceLicenseType.LicenseIncluded,
 *         Location = "Japan East",
 *         MaintenanceConfigurationId = "/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_MI_1",
 *         ManagedInstanceName = "testinstance",
 *         MinimalTlsVersion = "1.2",
 *         ProxyOverride = AzureNative.Sql.ManagedInstanceProxyOverride.Redirect,
 *         PublicDataEndpointEnabled = false,
 *         RequestedBackupStorageRedundancy = AzureNative.Sql.BackupStorageRedundancy.Geo,
 *         ResourceGroupName = "testrg",
 *         ServicePrincipal = new AzureNative.Sql.Inputs.ServicePrincipalArgs
 *         {
 *             Type = AzureNative.Sql.ServicePrincipalType.SystemAssigned,
 *         },
 *         Sku = new AzureNative.Sql.Inputs.SkuArgs
 *         {
 *             Name = "GP_Gen5",
 *             Tier = "GeneralPurpose",
 *         },
 *         StorageSizeInGB = 1024,
 *         SubnetId = "/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1",
 *         Tags =
 *         {
 *             { "tagKey1", "TagValue1" },
 *         },
 *         TimezoneId = "UTC",
 *         VCores = 8,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedInstance(ctx, "managedInstance", &sql.ManagedInstanceArgs{
 * 			AdministratorLogin:         pulumi.String("dummylogin"),
 * 			AdministratorLoginPassword: pulumi.String("PLACEHOLDER"),
 * 			Administrators: &sql.ManagedInstanceExternalAdministratorArgs{
 * 				AzureADOnlyAuthentication: pulumi.Bool(true),
 * 				Login:                     pulumi.String("bob@contoso.com"),
 * 				PrincipalType:             pulumi.String(sql.PrincipalTypeUser),
 * 				Sid:                       pulumi.String("00000011-1111-2222-2222-123456789111"),
 * 				TenantId:                  pulumi.String("00000011-1111-2222-2222-123456789111"),
 * 			},
 * 			Collation:                        pulumi.String("SQL_Latin1_General_CP1_CI_AS"),
 * 			DnsZonePartner:                   pulumi.String("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Sql/managedInstances/testinstance"),
 * 			InstancePoolId:                   pulumi.String("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Sql/instancePools/pool1"),
 * 			LicenseType:                      pulumi.String(sql.ManagedInstanceLicenseTypeLicenseIncluded),
 * 			Location:                         pulumi.String("Japan East"),
 * 			MaintenanceConfigurationId:       pulumi.String("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_MI_1"),
 * 			ManagedInstanceName:              pulumi.String("testinstance"),
 * 			MinimalTlsVersion:                pulumi.String("1.2"),
 * 			ProxyOverride:                    pulumi.String(sql.ManagedInstanceProxyOverrideRedirect),
 * 			PublicDataEndpointEnabled:        pulumi.Bool(false),
 * 			RequestedBackupStorageRedundancy: pulumi.String(sql.BackupStorageRedundancyGeo),
 * 			ResourceGroupName:                pulumi.String("testrg"),
 * 			ServicePrincipal: &sql.ServicePrincipalArgs{
 * 				Type: pulumi.String(sql.ServicePrincipalTypeSystemAssigned),
 * 			},
 * 			Sku: &sql.SkuArgs{
 * 				Name: pulumi.String("GP_Gen5"),
 * 				Tier: pulumi.String("GeneralPurpose"),
 * 			},
 * 			StorageSizeInGB: pulumi.Int(1024),
 * 			SubnetId:        pulumi.String("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
 * 			Tags: pulumi.StringMap{
 * 				"tagKey1": pulumi.String("TagValue1"),
 * 			},
 * 			TimezoneId: pulumi.String("UTC"),
 * 			VCores:     pulumi.Int(8),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedInstance;
 * import com.pulumi.azurenative.sql.ManagedInstanceArgs;
 * import com.pulumi.azurenative.sql.inputs.ManagedInstanceExternalAdministratorArgs;
 * import com.pulumi.azurenative.sql.inputs.ServicePrincipalArgs;
 * import com.pulumi.azurenative.sql.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedInstance = new ManagedInstance("managedInstance", ManagedInstanceArgs.builder()
 *             .administratorLogin("dummylogin")
 *             .administratorLoginPassword("PLACEHOLDER")
 *             .administrators(ManagedInstanceExternalAdministratorArgs.builder()
 *                 .azureADOnlyAuthentication(true)
 *                 .login("bob@contoso.com")
 *                 .principalType("User")
 *                 .sid("00000011-1111-2222-2222-123456789111")
 *                 .tenantId("00000011-1111-2222-2222-123456789111")
 *                 .build())
 *             .collation("SQL_Latin1_General_CP1_CI_AS")
 *             .dnsZonePartner("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Sql/managedInstances/testinstance")
 *             .instancePoolId("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Sql/instancePools/pool1")
 *             .licenseType("LicenseIncluded")
 *             .location("Japan East")
 *             .maintenanceConfigurationId("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/providers/Microsoft.Maintenance/publicMaintenanceConfigurations/SQL_JapanEast_MI_1")
 *             .managedInstanceName("testinstance")
 *             .minimalTlsVersion("1.2")
 *             .proxyOverride("Redirect")
 *             .publicDataEndpointEnabled(false)
 *             .requestedBackupStorageRedundancy("Geo")
 *             .resourceGroupName("testrg")
 *             .servicePrincipal(ServicePrincipalArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .sku(SkuArgs.builder()
 *                 .name("GP_Gen5")
 *                 .tier("GeneralPurpose")
 *                 .build())
 *             .storageSizeInGB(1024)
 *             .subnetId("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1")
 *             .tags(Map.of("tagKey1", "TagValue1"))
 *             .timezoneId("UTC")
 *             .vCores(8)
 *             .build());
 *     }
 * }
 * ```
 * ### Create managed instance with minimal properties
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedInstance = new AzureNative.Sql.ManagedInstance("managedInstance", new()
 *     {
 *         AdministratorLogin = "dummylogin",
 *         AdministratorLoginPassword = "PLACEHOLDER",
 *         LicenseType = AzureNative.Sql.ManagedInstanceLicenseType.LicenseIncluded,
 *         Location = "Japan East",
 *         ManagedInstanceName = "testinstance",
 *         ResourceGroupName = "testrg",
 *         Sku = new AzureNative.Sql.Inputs.SkuArgs
 *         {
 *             Name = "GP_Gen4",
 *             Tier = "GeneralPurpose",
 *         },
 *         StorageSizeInGB = 1024,
 *         SubnetId = "/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1",
 *         VCores = 8,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedInstance(ctx, "managedInstance", &sql.ManagedInstanceArgs{
 * 			AdministratorLogin:         pulumi.String("dummylogin"),
 * 			AdministratorLoginPassword: pulumi.String("PLACEHOLDER"),
 * 			LicenseType:                pulumi.String(sql.ManagedInstanceLicenseTypeLicenseIncluded),
 * 			Location:                   pulumi.String("Japan East"),
 * 			ManagedInstanceName:        pulumi.String("testinstance"),
 * 			ResourceGroupName:          pulumi.String("testrg"),
 * 			Sku: &sql.SkuArgs{
 * 				Name: pulumi.String("GP_Gen4"),
 * 				Tier: pulumi.String("GeneralPurpose"),
 * 			},
 * 			StorageSizeInGB: pulumi.Int(1024),
 * 			SubnetId:        pulumi.String("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
 * 			VCores:          pulumi.Int(8),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedInstance;
 * import com.pulumi.azurenative.sql.ManagedInstanceArgs;
 * import com.pulumi.azurenative.sql.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedInstance = new ManagedInstance("managedInstance", ManagedInstanceArgs.builder()
 *             .administratorLogin("dummylogin")
 *             .administratorLoginPassword("PLACEHOLDER")
 *             .licenseType("LicenseIncluded")
 *             .location("Japan East")
 *             .managedInstanceName("testinstance")
 *             .resourceGroupName("testrg")
 *             .sku(SkuArgs.builder()
 *                 .name("GP_Gen4")
 *                 .tier("GeneralPurpose")
 *                 .build())
 *             .storageSizeInGB(1024)
 *             .subnetId("/subscriptions/20D7082A-0FC7-4468-82BD-542694D5042B/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1")
 *             .vCores(8)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ManagedInstance testinstance /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}
 * ```
 * @property administratorLogin Administrator username for the managed instance. Can only be specified when the managed instance is being created (and is required for creation).
 * @property administratorLoginPassword The administrator login password (required for managed instance creation).
 * @property administrators The Azure Active Directory administrator of the server.
 * @property collation Collation of the managed instance.
 * @property dnsZonePartner The resource id of another managed instance whose DNS zone this managed instance will share after creation.
 * @property identity The Azure Active Directory identity of the managed instance.
 * @property instancePoolId The Id of the instance pool this managed server belongs to.
 * @property keyId A CMK URI of the key to use for encryption.
 * @property licenseType The license type. Possible values are 'LicenseIncluded' (regular price inclusive of a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL licenses).
 * @property location Resource location.
 * @property maintenanceConfigurationId Specifies maintenance configuration id to apply to this managed instance.
 * @property managedInstanceCreateMode Specifies the mode of database creation.
 * Default: Regular instance creation.
 * Restore: Creates an instance by restoring a set of backups to specific point in time. RestorePointInTime and SourceManagedInstanceId must be specified.
 * @property managedInstanceName The name of the managed instance.
 * @property minimalTlsVersion Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'
 * @property primaryUserAssignedIdentityId The resource id of a user assigned identity to be used by default.
 * @property proxyOverride Connection type used for connecting to the instance.
 * @property publicDataEndpointEnabled Whether or not the public data endpoint is enabled.
 * @property requestedBackupStorageRedundancy The storage account type to be used to store backups for this instance. The options are Local (LocallyRedundantStorage), Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage) and GeoZone(GeoZoneRedundantStorage)
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property restorePointInTime Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database.
 * @property servicePrincipal The managed instance's service principal.
 * @property sku Managed instance SKU. Allowed values for sku.name: GP_Gen5, GP_G8IM, GP_G8IH, BC_Gen5, BC_G8IM, BC_G8IH
 * @property sourceManagedInstanceId The resource identifier of the source managed instance associated with create operation of this instance.
 * @property storageSizeInGB Storage size in GB. Minimum value: 32. Maximum value: 16384. Increments of 32 GB allowed only. Maximum value depends on the selected hardware family and number of vCores.
 * @property subnetId Subnet resource ID for the managed instance.
 * @property tags Resource tags.
 * @property timezoneId Id of the timezone. Allowed values are timezones supported by Windows.
 * Windows keeps details on supported timezones, including the id, in registry under
 * KEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones.
 * You can get those registry values via SQL Server by querying SELECT name AS timezone_id FROM sys.time_zone_info.
 * List of Ids can also be obtained by executing [System&#46;TimeZoneInfo]::GetSystemTimeZones() in PowerShell.
 * An example of valid timezone id is "Pacific Standard Time" or "W. Europe Standard Time".
 * @property vCores The number of vCores. Allowed values: 8, 16, 24, 32, 40, 64, 80.
 * @property zoneRedundant Whether or not the multi-az is enabled.
 */
public data class ManagedInstanceArgs(
    public val administratorLogin: Output<String>? = null,
    public val administratorLoginPassword: Output<String>? = null,
    public val administrators: Output<ManagedInstanceExternalAdministratorArgs>? = null,
    public val collation: Output<String>? = null,
    public val dnsZonePartner: Output<String>? = null,
    public val identity: Output<ResourceIdentityArgs>? = null,
    public val instancePoolId: Output<String>? = null,
    public val keyId: Output<String>? = null,
    public val licenseType: Output<Either<String, ManagedInstanceLicenseType>>? = null,
    public val location: Output<String>? = null,
    public val maintenanceConfigurationId: Output<String>? = null,
    public val managedInstanceCreateMode: Output<Either<String, ManagedServerCreateMode>>? = null,
    public val managedInstanceName: Output<String>? = null,
    public val minimalTlsVersion: Output<String>? = null,
    public val primaryUserAssignedIdentityId: Output<String>? = null,
    public val proxyOverride: Output<Either<String, ManagedInstanceProxyOverride>>? = null,
    public val publicDataEndpointEnabled: Output<Boolean>? = null,
    public val requestedBackupStorageRedundancy: Output<Either<String, BackupStorageRedundancy>>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val restorePointInTime: Output<String>? = null,
    public val servicePrincipal: Output<ServicePrincipalArgs>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val sourceManagedInstanceId: Output<String>? = null,
    public val storageSizeInGB: Output<Int>? = null,
    public val subnetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timezoneId: Output<String>? = null,
    public val vCores: Output<Int>? = null,
    public val zoneRedundant: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.ManagedInstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.ManagedInstanceArgs =
        com.pulumi.azurenative.sql.ManagedInstanceArgs.builder()
            .administratorLogin(administratorLogin?.applyValue({ args0 -> args0 }))
            .administratorLoginPassword(administratorLoginPassword?.applyValue({ args0 -> args0 }))
            .administrators(administrators?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .collation(collation?.applyValue({ args0 -> args0 }))
            .dnsZonePartner(dnsZonePartner?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .instancePoolId(instancePoolId?.applyValue({ args0 -> args0 }))
            .keyId(keyId?.applyValue({ args0 -> args0 }))
            .licenseType(
                licenseType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .maintenanceConfigurationId(maintenanceConfigurationId?.applyValue({ args0 -> args0 }))
            .managedInstanceCreateMode(
                managedInstanceCreateMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .managedInstanceName(managedInstanceName?.applyValue({ args0 -> args0 }))
            .minimalTlsVersion(minimalTlsVersion?.applyValue({ args0 -> args0 }))
            .primaryUserAssignedIdentityId(primaryUserAssignedIdentityId?.applyValue({ args0 -> args0 }))
            .proxyOverride(
                proxyOverride?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .publicDataEndpointEnabled(publicDataEndpointEnabled?.applyValue({ args0 -> args0 }))
            .requestedBackupStorageRedundancy(
                requestedBackupStorageRedundancy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .restorePointInTime(restorePointInTime?.applyValue({ args0 -> args0 }))
            .servicePrincipal(servicePrincipal?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceManagedInstanceId(sourceManagedInstanceId?.applyValue({ args0 -> args0 }))
            .storageSizeInGB(storageSizeInGB?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timezoneId(timezoneId?.applyValue({ args0 -> args0 }))
            .vCores(vCores?.applyValue({ args0 -> args0 }))
            .zoneRedundant(zoneRedundant?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedInstanceArgs].
 */
@PulumiTagMarker
public class ManagedInstanceArgsBuilder internal constructor() {
    private var administratorLogin: Output<String>? = null

    private var administratorLoginPassword: Output<String>? = null

    private var administrators: Output<ManagedInstanceExternalAdministratorArgs>? = null

    private var collation: Output<String>? = null

    private var dnsZonePartner: Output<String>? = null

    private var identity: Output<ResourceIdentityArgs>? = null

    private var instancePoolId: Output<String>? = null

    private var keyId: Output<String>? = null

    private var licenseType: Output<Either<String, ManagedInstanceLicenseType>>? = null

    private var location: Output<String>? = null

    private var maintenanceConfigurationId: Output<String>? = null

    private var managedInstanceCreateMode: Output<Either<String, ManagedServerCreateMode>>? = null

    private var managedInstanceName: Output<String>? = null

    private var minimalTlsVersion: Output<String>? = null

    private var primaryUserAssignedIdentityId: Output<String>? = null

    private var proxyOverride: Output<Either<String, ManagedInstanceProxyOverride>>? = null

    private var publicDataEndpointEnabled: Output<Boolean>? = null

    private var requestedBackupStorageRedundancy: Output<Either<String, BackupStorageRedundancy>>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var restorePointInTime: Output<String>? = null

    private var servicePrincipal: Output<ServicePrincipalArgs>? = null

    private var sku: Output<SkuArgs>? = null

    private var sourceManagedInstanceId: Output<String>? = null

    private var storageSizeInGB: Output<Int>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timezoneId: Output<String>? = null

    private var vCores: Output<Int>? = null

    private var zoneRedundant: Output<Boolean>? = null

    /**
     * @param value Administrator username for the managed instance. Can only be specified when the managed instance is being created (and is required for creation).
     */
    @JvmName("fuejphcjityprxyd")
    public suspend fun administratorLogin(`value`: Output<String>) {
        this.administratorLogin = value
    }

    /**
     * @param value The administrator login password (required for managed instance creation).
     */
    @JvmName("vstutdvjepgpepgo")
    public suspend fun administratorLoginPassword(`value`: Output<String>) {
        this.administratorLoginPassword = value
    }

    /**
     * @param value The Azure Active Directory administrator of the server.
     */
    @JvmName("pmxcichdhggybdky")
    public suspend fun administrators(`value`: Output<ManagedInstanceExternalAdministratorArgs>) {
        this.administrators = value
    }

    /**
     * @param value Collation of the managed instance.
     */
    @JvmName("yooaaieteiactfbf")
    public suspend fun collation(`value`: Output<String>) {
        this.collation = value
    }

    /**
     * @param value The resource id of another managed instance whose DNS zone this managed instance will share after creation.
     */
    @JvmName("myteykqrhsnmryjs")
    public suspend fun dnsZonePartner(`value`: Output<String>) {
        this.dnsZonePartner = value
    }

    /**
     * @param value The Azure Active Directory identity of the managed instance.
     */
    @JvmName("ixkegpqxowyhaxse")
    public suspend fun identity(`value`: Output<ResourceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The Id of the instance pool this managed server belongs to.
     */
    @JvmName("bobimdechyrqqngy")
    public suspend fun instancePoolId(`value`: Output<String>) {
        this.instancePoolId = value
    }

    /**
     * @param value A CMK URI of the key to use for encryption.
     */
    @JvmName("mrqnsqrfmrklbvcp")
    public suspend fun keyId(`value`: Output<String>) {
        this.keyId = value
    }

    /**
     * @param value The license type. Possible values are 'LicenseIncluded' (regular price inclusive of a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL licenses).
     */
    @JvmName("jnwkchicunykfyre")
    public suspend fun licenseType(`value`: Output<Either<String, ManagedInstanceLicenseType>>) {
        this.licenseType = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("xsibcpswukbftvfm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Specifies maintenance configuration id to apply to this managed instance.
     */
    @JvmName("buhilwmbwdfbivqt")
    public suspend fun maintenanceConfigurationId(`value`: Output<String>) {
        this.maintenanceConfigurationId = value
    }

    /**
     * @param value Specifies the mode of database creation.
     * Default: Regular instance creation.
     * Restore: Creates an instance by restoring a set of backups to specific point in time. RestorePointInTime and SourceManagedInstanceId must be specified.
     */
    @JvmName("acqarbousgggiwlb")
    public suspend fun managedInstanceCreateMode(`value`: Output<Either<String, ManagedServerCreateMode>>) {
        this.managedInstanceCreateMode = value
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("lyvlffrksesoyxut")
    public suspend fun managedInstanceName(`value`: Output<String>) {
        this.managedInstanceName = value
    }

    /**
     * @param value Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'
     */
    @JvmName("wtchcbogtwmtkysc")
    public suspend fun minimalTlsVersion(`value`: Output<String>) {
        this.minimalTlsVersion = value
    }

    /**
     * @param value The resource id of a user assigned identity to be used by default.
     */
    @JvmName("dmjpyewpujjvvmen")
    public suspend fun primaryUserAssignedIdentityId(`value`: Output<String>) {
        this.primaryUserAssignedIdentityId = value
    }

    /**
     * @param value Connection type used for connecting to the instance.
     */
    @JvmName("lwefmwegpmurdsuy")
    public suspend fun proxyOverride(`value`: Output<Either<String, ManagedInstanceProxyOverride>>) {
        this.proxyOverride = value
    }

    /**
     * @param value Whether or not the public data endpoint is enabled.
     */
    @JvmName("rbprvdsoqqllgefm")
    public suspend fun publicDataEndpointEnabled(`value`: Output<Boolean>) {
        this.publicDataEndpointEnabled = value
    }

    /**
     * @param value The storage account type to be used to store backups for this instance. The options are Local (LocallyRedundantStorage), Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage) and GeoZone(GeoZoneRedundantStorage)
     */
    @JvmName("lapgpfygdddhdthr")
    public suspend fun requestedBackupStorageRedundancy(`value`: Output<Either<String, BackupStorageRedundancy>>) {
        this.requestedBackupStorageRedundancy = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("cadjwarspjxifkdf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database.
     */
    @JvmName("ijhubwedhdwvckbi")
    public suspend fun restorePointInTime(`value`: Output<String>) {
        this.restorePointInTime = value
    }

    /**
     * @param value The managed instance's service principal.
     */
    @JvmName("ykaqwtowdlpxvwwu")
    public suspend fun servicePrincipal(`value`: Output<ServicePrincipalArgs>) {
        this.servicePrincipal = value
    }

    /**
     * @param value Managed instance SKU. Allowed values for sku.name: GP_Gen5, GP_G8IM, GP_G8IH, BC_Gen5, BC_G8IM, BC_G8IH
     */
    @JvmName("uivqlclrjwydcedo")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The resource identifier of the source managed instance associated with create operation of this instance.
     */
    @JvmName("gfiuwvfnvbbsuvcr")
    public suspend fun sourceManagedInstanceId(`value`: Output<String>) {
        this.sourceManagedInstanceId = value
    }

    /**
     * @param value Storage size in GB. Minimum value: 32. Maximum value: 16384. Increments of 32 GB allowed only. Maximum value depends on the selected hardware family and number of vCores.
     */
    @JvmName("amuanyfndjknkmwp")
    public suspend fun storageSizeInGB(`value`: Output<Int>) {
        this.storageSizeInGB = value
    }

    /**
     * @param value Subnet resource ID for the managed instance.
     */
    @JvmName("jtruywpcgmnodvxc")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cilkeeemalcaueov")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Id of the timezone. Allowed values are timezones supported by Windows.
     * Windows keeps details on supported timezones, including the id, in registry under
     * KEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones.
     * You can get those registry values via SQL Server by querying SELECT name AS timezone_id FROM sys.time_zone_info.
     * List of Ids can also be obtained by executing [System&#46;TimeZoneInfo]::GetSystemTimeZones() in PowerShell.
     * An example of valid timezone id is "Pacific Standard Time" or "W. Europe Standard Time".
     */
    @JvmName("gqfdqgwayfvgqpjl")
    public suspend fun timezoneId(`value`: Output<String>) {
        this.timezoneId = value
    }

    /**
     * @param value The number of vCores. Allowed values: 8, 16, 24, 32, 40, 64, 80.
     */
    @JvmName("cfidqflqnxsphqle")
    public suspend fun vCores(`value`: Output<Int>) {
        this.vCores = value
    }

    /**
     * @param value Whether or not the multi-az is enabled.
     */
    @JvmName("bmekaoxmykcidjdf")
    public suspend fun zoneRedundant(`value`: Output<Boolean>) {
        this.zoneRedundant = value
    }

    /**
     * @param value Administrator username for the managed instance. Can only be specified when the managed instance is being created (and is required for creation).
     */
    @JvmName("wlpylafadexkysfv")
    public suspend fun administratorLogin(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorLogin = mapped
    }

    /**
     * @param value The administrator login password (required for managed instance creation).
     */
    @JvmName("xqgiiqavipaltmyk")
    public suspend fun administratorLoginPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorLoginPassword = mapped
    }

    /**
     * @param value The Azure Active Directory administrator of the server.
     */
    @JvmName("sqkukrspnvgajqag")
    public suspend fun administrators(`value`: ManagedInstanceExternalAdministratorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administrators = mapped
    }

    /**
     * @param argument The Azure Active Directory administrator of the server.
     */
    @JvmName("fxhqqeskjmlcqgpm")
    public suspend fun administrators(argument: suspend ManagedInstanceExternalAdministratorArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedInstanceExternalAdministratorArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.administrators = mapped
    }

    /**
     * @param value Collation of the managed instance.
     */
    @JvmName("iclxvgdyvgfpifbt")
    public suspend fun collation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collation = mapped
    }

    /**
     * @param value The resource id of another managed instance whose DNS zone this managed instance will share after creation.
     */
    @JvmName("prfwadadihdaixsd")
    public suspend fun dnsZonePartner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsZonePartner = mapped
    }

    /**
     * @param value The Azure Active Directory identity of the managed instance.
     */
    @JvmName("iaqrtfuaaavpfkju")
    public suspend fun identity(`value`: ResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The Azure Active Directory identity of the managed instance.
     */
    @JvmName("sadxiknoqfdxatse")
    public suspend fun identity(argument: suspend ResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The Id of the instance pool this managed server belongs to.
     */
    @JvmName("pyaedkdtjivrdyal")
    public suspend fun instancePoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instancePoolId = mapped
    }

    /**
     * @param value A CMK URI of the key to use for encryption.
     */
    @JvmName("tiscqxhnidwmtoqs")
    public suspend fun keyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyId = mapped
    }

    /**
     * @param value The license type. Possible values are 'LicenseIncluded' (regular price inclusive of a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL licenses).
     */
    @JvmName("ymkfrurfmvddkxoi")
    public suspend fun licenseType(`value`: Either<String, ManagedInstanceLicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The license type. Possible values are 'LicenseIncluded' (regular price inclusive of a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL licenses).
     */
    @JvmName("spngboowuiaagpod")
    public fun licenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedInstanceLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The license type. Possible values are 'LicenseIncluded' (regular price inclusive of a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL licenses).
     */
    @JvmName("pcfqjbrvwyjxvvfh")
    public fun licenseType(`value`: ManagedInstanceLicenseType) {
        val toBeMapped = Either.ofRight<String, ManagedInstanceLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("vxwoeeqahssharru")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Specifies maintenance configuration id to apply to this managed instance.
     */
    @JvmName("fnxmxyvffcwkribj")
    public suspend fun maintenanceConfigurationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceConfigurationId = mapped
    }

    /**
     * @param value Specifies the mode of database creation.
     * Default: Regular instance creation.
     * Restore: Creates an instance by restoring a set of backups to specific point in time. RestorePointInTime and SourceManagedInstanceId must be specified.
     */
    @JvmName("noretnaafaywsruh")
    public suspend fun managedInstanceCreateMode(`value`: Either<String, ManagedServerCreateMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedInstanceCreateMode = mapped
    }

    /**
     * @param value Specifies the mode of database creation.
     * Default: Regular instance creation.
     * Restore: Creates an instance by restoring a set of backups to specific point in time. RestorePointInTime and SourceManagedInstanceId must be specified.
     */
    @JvmName("cqmhuuekqrsbhmmc")
    public fun managedInstanceCreateMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedServerCreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedInstanceCreateMode = mapped
    }

    /**
     * @param value Specifies the mode of database creation.
     * Default: Regular instance creation.
     * Restore: Creates an instance by restoring a set of backups to specific point in time. RestorePointInTime and SourceManagedInstanceId must be specified.
     */
    @JvmName("qxxvethkosobftic")
    public fun managedInstanceCreateMode(`value`: ManagedServerCreateMode) {
        val toBeMapped = Either.ofRight<String, ManagedServerCreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedInstanceCreateMode = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("fiqgrvthogrgbdqx")
    public suspend fun managedInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedInstanceName = mapped
    }

    /**
     * @param value Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'
     */
    @JvmName("muclaybposolykwf")
    public suspend fun minimalTlsVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimalTlsVersion = mapped
    }

    /**
     * @param value The resource id of a user assigned identity to be used by default.
     */
    @JvmName("yoebwvucohsynxgu")
    public suspend fun primaryUserAssignedIdentityId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryUserAssignedIdentityId = mapped
    }

    /**
     * @param value Connection type used for connecting to the instance.
     */
    @JvmName("djepacfgmvppyqch")
    public suspend fun proxyOverride(`value`: Either<String, ManagedInstanceProxyOverride>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyOverride = mapped
    }

    /**
     * @param value Connection type used for connecting to the instance.
     */
    @JvmName("sopayksvrstiqaul")
    public fun proxyOverride(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedInstanceProxyOverride>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.proxyOverride = mapped
    }

    /**
     * @param value Connection type used for connecting to the instance.
     */
    @JvmName("naxdfjrkniwcabcf")
    public fun proxyOverride(`value`: ManagedInstanceProxyOverride) {
        val toBeMapped = Either.ofRight<String, ManagedInstanceProxyOverride>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.proxyOverride = mapped
    }

    /**
     * @param value Whether or not the public data endpoint is enabled.
     */
    @JvmName("vmsutoneufsdpqut")
    public suspend fun publicDataEndpointEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicDataEndpointEnabled = mapped
    }

    /**
     * @param value The storage account type to be used to store backups for this instance. The options are Local (LocallyRedundantStorage), Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage) and GeoZone(GeoZoneRedundantStorage)
     */
    @JvmName("gceyuefptjdeaeke")
    public suspend fun requestedBackupStorageRedundancy(`value`: Either<String, BackupStorageRedundancy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestedBackupStorageRedundancy = mapped
    }

    /**
     * @param value The storage account type to be used to store backups for this instance. The options are Local (LocallyRedundantStorage), Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage) and GeoZone(GeoZoneRedundantStorage)
     */
    @JvmName("oddcmdirfjimxjjs")
    public fun requestedBackupStorageRedundancy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BackupStorageRedundancy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestedBackupStorageRedundancy = mapped
    }

    /**
     * @param value The storage account type to be used to store backups for this instance. The options are Local (LocallyRedundantStorage), Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage) and GeoZone(GeoZoneRedundantStorage)
     */
    @JvmName("hsqlfcdurwodxugg")
    public fun requestedBackupStorageRedundancy(`value`: BackupStorageRedundancy) {
        val toBeMapped = Either.ofRight<String, BackupStorageRedundancy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestedBackupStorageRedundancy = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("tsnsnhttykcjigwo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database.
     */
    @JvmName("momxxyaxilddaxct")
    public suspend fun restorePointInTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restorePointInTime = mapped
    }

    /**
     * @param value The managed instance's service principal.
     */
    @JvmName("xuhmbshyihvckaka")
    public suspend fun servicePrincipal(`value`: ServicePrincipalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipal = mapped
    }

    /**
     * @param argument The managed instance's service principal.
     */
    @JvmName("bimvodbneolrsrag")
    public suspend fun servicePrincipal(argument: suspend ServicePrincipalArgsBuilder.() -> Unit) {
        val toBeMapped = ServicePrincipalArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.servicePrincipal = mapped
    }

    /**
     * @param value Managed instance SKU. Allowed values for sku.name: GP_Gen5, GP_G8IM, GP_G8IH, BC_Gen5, BC_G8IM, BC_G8IH
     */
    @JvmName("djnvemsltjnorbfc")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Managed instance SKU. Allowed values for sku.name: GP_Gen5, GP_G8IM, GP_G8IH, BC_Gen5, BC_G8IM, BC_G8IH
     */
    @JvmName("sgturvefybcswbgp")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The resource identifier of the source managed instance associated with create operation of this instance.
     */
    @JvmName("ovlmhknlahlevpps")
    public suspend fun sourceManagedInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceManagedInstanceId = mapped
    }

    /**
     * @param value Storage size in GB. Minimum value: 32. Maximum value: 16384. Increments of 32 GB allowed only. Maximum value depends on the selected hardware family and number of vCores.
     */
    @JvmName("gqdycqwoepgacmgm")
    public suspend fun storageSizeInGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSizeInGB = mapped
    }

    /**
     * @param value Subnet resource ID for the managed instance.
     */
    @JvmName("hqxbkkuymiqojxpr")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cxhdmqpfushsywpe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nevwdrttkhiwolke")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Id of the timezone. Allowed values are timezones supported by Windows.
     * Windows keeps details on supported timezones, including the id, in registry under
     * KEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones.
     * You can get those registry values via SQL Server by querying SELECT name AS timezone_id FROM sys.time_zone_info.
     * List of Ids can also be obtained by executing [System&#46;TimeZoneInfo]::GetSystemTimeZones() in PowerShell.
     * An example of valid timezone id is "Pacific Standard Time" or "W. Europe Standard Time".
     */
    @JvmName("bjufvjtenbrmbppx")
    public suspend fun timezoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timezoneId = mapped
    }

    /**
     * @param value The number of vCores. Allowed values: 8, 16, 24, 32, 40, 64, 80.
     */
    @JvmName("cpcomejqfpfylnrm")
    public suspend fun vCores(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vCores = mapped
    }

    /**
     * @param value Whether or not the multi-az is enabled.
     */
    @JvmName("mdvpqropaaydjspx")
    public suspend fun zoneRedundant(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneRedundant = mapped
    }

    internal fun build(): ManagedInstanceArgs = ManagedInstanceArgs(
        administratorLogin = administratorLogin,
        administratorLoginPassword = administratorLoginPassword,
        administrators = administrators,
        collation = collation,
        dnsZonePartner = dnsZonePartner,
        identity = identity,
        instancePoolId = instancePoolId,
        keyId = keyId,
        licenseType = licenseType,
        location = location,
        maintenanceConfigurationId = maintenanceConfigurationId,
        managedInstanceCreateMode = managedInstanceCreateMode,
        managedInstanceName = managedInstanceName,
        minimalTlsVersion = minimalTlsVersion,
        primaryUserAssignedIdentityId = primaryUserAssignedIdentityId,
        proxyOverride = proxyOverride,
        publicDataEndpointEnabled = publicDataEndpointEnabled,
        requestedBackupStorageRedundancy = requestedBackupStorageRedundancy,
        resourceGroupName = resourceGroupName,
        restorePointInTime = restorePointInTime,
        servicePrincipal = servicePrincipal,
        sku = sku,
        sourceManagedInstanceId = sourceManagedInstanceId,
        storageSizeInGB = storageSizeInGB,
        subnetId = subnetId,
        tags = tags,
        timezoneId = timezoneId,
        vCores = vCores,
        zoneRedundant = zoneRedundant,
    )
}
