@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [OutboundFirewallRule].
 */
@PulumiTagMarker
public class OutboundFirewallRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OutboundFirewallRuleArgs = OutboundFirewallRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OutboundFirewallRuleArgsBuilder.() -> Unit) {
        val builder = OutboundFirewallRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OutboundFirewallRule {
        val builtJavaResource = com.pulumi.azurenative.sql.OutboundFirewallRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OutboundFirewallRule(builtJavaResource)
    }
}

/**
 * An Azure SQL DB Server Outbound Firewall Rule.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Approve or reject a outbound firewall rule with a given name.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var outboundFirewallRule = new AzureNative.Sql.OutboundFirewallRule("outboundFirewallRule", new()
 *     {
 *         OutboundRuleFqdn = "server.database.windows.net",
 *         ResourceGroupName = "sqlcrudtest-7398",
 *         ServerName = "sqlcrudtest-4645",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewOutboundFirewallRule(ctx, "outboundFirewallRule", &sql.OutboundFirewallRuleArgs{
 * 			OutboundRuleFqdn:  pulumi.String("server.database.windows.net"),
 * 			ResourceGroupName: pulumi.String("sqlcrudtest-7398"),
 * 			ServerName:        pulumi.String("sqlcrudtest-4645"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.OutboundFirewallRule;
 * import com.pulumi.azurenative.sql.OutboundFirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var outboundFirewallRule = new OutboundFirewallRule("outboundFirewallRule", OutboundFirewallRuleArgs.builder()
 *             .outboundRuleFqdn("server.database.windows.net")
 *             .resourceGroupName("sqlcrudtest-7398")
 *             .serverName("sqlcrudtest-4645")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:OutboundFirewallRule server.database.windows.net /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/outboundFirewallRules/{outboundRuleFqdn}
 * ```
 */
public class OutboundFirewallRule internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.OutboundFirewallRule,
) : KotlinCustomResource(javaResource, OutboundFirewallRuleMapper) {
    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The state of the outbound rule.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object OutboundFirewallRuleMapper : ResourceMapper<OutboundFirewallRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.OutboundFirewallRule::class == javaResource::class

    override fun map(javaResource: Resource): OutboundFirewallRule = OutboundFirewallRule(
        javaResource
            as com.pulumi.azurenative.sql.OutboundFirewallRule,
    )
}

/**
 * @see [OutboundFirewallRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OutboundFirewallRule].
 */
public suspend fun outboundFirewallRule(
    name: String,
    block: suspend OutboundFirewallRuleResourceBuilder.() -> Unit,
): OutboundFirewallRule {
    val builder = OutboundFirewallRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OutboundFirewallRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun outboundFirewallRule(name: String): OutboundFirewallRule {
    val builder = OutboundFirewallRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
