@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ReplicationLink].
 */
@PulumiTagMarker
public class ReplicationLinkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationLinkArgs = ReplicationLinkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationLinkArgsBuilder.() -> Unit) {
        val builder = ReplicationLinkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ReplicationLink {
        val builtJavaResource = com.pulumi.azurenative.sql.ReplicationLink(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReplicationLink(builtJavaResource)
    }
}

/**
 * A replication link.
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-08-01-preview.
 * ## Example Usage
 * ### Updates Replication Link
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationLink = new AzureNative.Sql.ReplicationLink("replicationLink", new()
 *     {
 *         DatabaseName = "gamma-db",
 *         LinkId = "00000000-1111-2222-3333-666666666666",
 *         LinkType = AzureNative.Sql.ReplicationLinkType.STANDBY,
 *         ResourceGroupName = "Default",
 *         ServerName = "sourcesvr",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewReplicationLink(ctx, "replicationLink", &sql.ReplicationLinkArgs{
 * 			DatabaseName:      pulumi.String("gamma-db"),
 * 			LinkId:            pulumi.String("00000000-1111-2222-3333-666666666666"),
 * 			LinkType:          pulumi.String(sql.ReplicationLinkTypeSTANDBY),
 * 			ResourceGroupName: pulumi.String("Default"),
 * 			ServerName:        pulumi.String("sourcesvr"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ReplicationLink;
 * import com.pulumi.azurenative.sql.ReplicationLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationLink = new ReplicationLink("replicationLink", ReplicationLinkArgs.builder()
 *             .databaseName("gamma-db")
 *             .linkId("00000000-1111-2222-3333-666666666666")
 *             .linkType("STANDBY")
 *             .resourceGroupName("Default")
 *             .serverName("sourcesvr")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ReplicationLink 00000000-1111-2222-3333-666666666666 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/replicationLinks/{linkId}
 * ```
 */
public class ReplicationLink internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.ReplicationLink,
) : KotlinCustomResource(javaResource, ReplicationLinkMapper) {
    /**
     * Whether the user is currently allowed to terminate the link.
     */
    public val isTerminationAllowed: Output<Boolean>
        get() = javaResource.isTerminationAllowed().applyValue({ args0 -> args0 })

    /**
     * Link type (GEO, NAMED, STANDBY). Update operation does not support NAMED.
     */
    public val linkType: Output<String>?
        get() = javaResource.linkType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource partner database.
     */
    public val partnerDatabase: Output<String>
        get() = javaResource.partnerDatabase().applyValue({ args0 -> args0 })

    /**
     * Resource partner database Id.
     */
    public val partnerDatabaseId: Output<String>
        get() = javaResource.partnerDatabaseId().applyValue({ args0 -> args0 })

    /**
     * Resource partner location.
     */
    public val partnerLocation: Output<String>
        get() = javaResource.partnerLocation().applyValue({ args0 -> args0 })

    /**
     * Partner replication role.
     */
    public val partnerRole: Output<String>
        get() = javaResource.partnerRole().applyValue({ args0 -> args0 })

    /**
     * Resource partner server.
     */
    public val partnerServer: Output<String>
        get() = javaResource.partnerServer().applyValue({ args0 -> args0 })

    /**
     * Seeding completion percentage for the link.
     */
    public val percentComplete: Output<Int>
        get() = javaResource.percentComplete().applyValue({ args0 -> args0 })

    /**
     * Replication mode.
     */
    public val replicationMode: Output<String>
        get() = javaResource.replicationMode().applyValue({ args0 -> args0 })

    /**
     * Replication state (PENDING, SEEDING, CATCHUP, SUSPENDED).
     */
    public val replicationState: Output<String>
        get() = javaResource.replicationState().applyValue({ args0 -> args0 })

    /**
     * Local replication role.
     */
    public val role: Output<String>
        get() = javaResource.role().applyValue({ args0 -> args0 })

    /**
     * Time at which the link was created.
     */
    public val startTime: Output<String>
        get() = javaResource.startTime().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ReplicationLinkMapper : ResourceMapper<ReplicationLink> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.ReplicationLink::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationLink = ReplicationLink(
        javaResource as
            com.pulumi.azurenative.sql.ReplicationLink,
    )
}

/**
 * @see [ReplicationLink].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationLink].
 */
public suspend fun replicationLink(
    name: String,
    block: suspend ReplicationLinkResourceBuilder.() -> Unit,
): ReplicationLink {
    val builder = ReplicationLinkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationLink].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationLink(name: String): ReplicationLink {
    val builder = ReplicationLinkResourceBuilder()
    builder.name(name)
    return builder.build()
}
