@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ServerAdvisorArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.AutoExecuteStatus
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Database, Server or Elastic Pool Advisor.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2014-04-01, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Update server advisor
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverAdvisor = new AzureNative.Sql.ServerAdvisor("serverAdvisor", new()
 *     {
 *         AdvisorName = "CreateIndex",
 *         AutoExecuteStatus = AzureNative.Sql.AutoExecuteStatus.Disabled,
 *         ResourceGroupName = "workloadinsight-demos",
 *         ServerName = "misosisvr",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewServerAdvisor(ctx, "serverAdvisor", &sql.ServerAdvisorArgs{
 * 			AdvisorName:       pulumi.String("CreateIndex"),
 * 			AutoExecuteStatus: sql.AutoExecuteStatusDisabled,
 * 			ResourceGroupName: pulumi.String("workloadinsight-demos"),
 * 			ServerName:        pulumi.String("misosisvr"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ServerAdvisor;
 * import com.pulumi.azurenative.sql.ServerAdvisorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverAdvisor = new ServerAdvisor("serverAdvisor", ServerAdvisorArgs.builder()
 *             .advisorName("CreateIndex")
 *             .autoExecuteStatus("Disabled")
 *             .resourceGroupName("workloadinsight-demos")
 *             .serverName("misosisvr")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ServerAdvisor CreateIndex /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/advisors/{advisorName}
 * ```
 * @property advisorName The name of the Server Advisor.
 * @property autoExecuteStatus Gets the auto-execute status (whether to let the system execute the recommendations) of this advisor. Possible values are 'Enabled' and 'Disabled'
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class ServerAdvisorArgs(
    public val advisorName: Output<String>? = null,
    public val autoExecuteStatus: Output<AutoExecuteStatus>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.ServerAdvisorArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.ServerAdvisorArgs =
        com.pulumi.azurenative.sql.ServerAdvisorArgs.builder()
            .advisorName(advisorName?.applyValue({ args0 -> args0 }))
            .autoExecuteStatus(autoExecuteStatus?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerAdvisorArgs].
 */
@PulumiTagMarker
public class ServerAdvisorArgsBuilder internal constructor() {
    private var advisorName: Output<String>? = null

    private var autoExecuteStatus: Output<AutoExecuteStatus>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    /**
     * @param value The name of the Server Advisor.
     */
    @JvmName("gtagawnnnevefbge")
    public suspend fun advisorName(`value`: Output<String>) {
        this.advisorName = value
    }

    /**
     * @param value Gets the auto-execute status (whether to let the system execute the recommendations) of this advisor. Possible values are 'Enabled' and 'Disabled'
     */
    @JvmName("adwrfcrweyogasom")
    public suspend fun autoExecuteStatus(`value`: Output<AutoExecuteStatus>) {
        this.autoExecuteStatus = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ualmnyfjhduoycst")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("nrcxcgiidnrjutox")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The name of the Server Advisor.
     */
    @JvmName("rcjasxvcsxqqocmv")
    public suspend fun advisorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advisorName = mapped
    }

    /**
     * @param value Gets the auto-execute status (whether to let the system execute the recommendations) of this advisor. Possible values are 'Enabled' and 'Disabled'
     */
    @JvmName("jxlympicdoctltju")
    public suspend fun autoExecuteStatus(`value`: AutoExecuteStatus?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoExecuteStatus = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("jfqwpdxuepxtiqcx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("ghoyfirdwnjcsuov")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    internal fun build(): ServerAdvisorArgs = ServerAdvisorArgs(
        advisorName = advisorName,
        autoExecuteStatus = autoExecuteStatus,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
    )
}
