@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ServerArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.ServerNetworkAccessFlag
import com.pulumi.azurenative.sql.kotlin.inputs.ResourceIdentityArgs
import com.pulumi.azurenative.sql.kotlin.inputs.ResourceIdentityArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.ServerExternalAdministratorArgs
import com.pulumi.azurenative.sql.kotlin.inputs.ServerExternalAdministratorArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure SQL Database server.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2014-04-01, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * **Warning:** when `AzureADOnlyAuthentication` is enabled, the Azure SQL API rejects any `AdministratorLoginPassword`, even if it is the same as the current one.
 * According to the Azure team, this API design owes to the following reasons:
 * - Changing the password is not allowed when Entra-only authentication is enabled because it could lead to invalid templates.
 * - Any updates containing the same, unchanged password are also rejected because different behavior for same vs different passwords would be a vector for brute forcing the password.
 * To work around this, you can comment out `AdministratorLoginPassword` when enabling `AzureADOnlyAuthentication`. To update the password, you can disable `AzureADOnlyAuthentication` and re-enable it after the update.
 * For more details and discussion please see [this issue](https://github.com/pulumi/pulumi-azure-native/issues/2937).
 * ## Example Usage
 * ### Create server
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.Sql.Server("server", new()
 *     {
 *         AdministratorLogin = "dummylogin",
 *         AdministratorLoginPassword = "PLACEHOLDER",
 *         Administrators = new AzureNative.Sql.Inputs.ServerExternalAdministratorArgs
 *         {
 *             AzureADOnlyAuthentication = true,
 *             Login = "bob@contoso.com",
 *             PrincipalType = AzureNative.Sql.PrincipalType.User,
 *             Sid = "00000011-1111-2222-2222-123456789111",
 *             TenantId = "00000011-1111-2222-2222-123456789111",
 *         },
 *         Location = "Japan East",
 *         PublicNetworkAccess = AzureNative.Sql.ServerNetworkAccessFlag.Enabled,
 *         ResourceGroupName = "sqlcrudtest-7398",
 *         RestrictOutboundNetworkAccess = AzureNative.Sql.ServerNetworkAccessFlag.Enabled,
 *         ServerName = "sqlcrudtest-4645",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewServer(ctx, "server", &sql.ServerArgs{
 * 			AdministratorLogin:         pulumi.String("dummylogin"),
 * 			AdministratorLoginPassword: pulumi.String("PLACEHOLDER"),
 * 			Administrators: &sql.ServerExternalAdministratorArgs{
 * 				AzureADOnlyAuthentication: pulumi.Bool(true),
 * 				Login:                     pulumi.String("bob@contoso.com"),
 * 				PrincipalType:             pulumi.String(sql.PrincipalTypeUser),
 * 				Sid:                       pulumi.String("00000011-1111-2222-2222-123456789111"),
 * 				TenantId:                  pulumi.String("00000011-1111-2222-2222-123456789111"),
 * 			},
 * 			Location:                      pulumi.String("Japan East"),
 * 			PublicNetworkAccess:           pulumi.String(sql.ServerNetworkAccessFlagEnabled),
 * 			ResourceGroupName:             pulumi.String("sqlcrudtest-7398"),
 * 			RestrictOutboundNetworkAccess: pulumi.String(sql.ServerNetworkAccessFlagEnabled),
 * 			ServerName:                    pulumi.String("sqlcrudtest-4645"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.Server;
 * import com.pulumi.azurenative.sql.ServerArgs;
 * import com.pulumi.azurenative.sql.inputs.ServerExternalAdministratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .administratorLogin("dummylogin")
 *             .administratorLoginPassword("PLACEHOLDER")
 *             .administrators(ServerExternalAdministratorArgs.builder()
 *                 .azureADOnlyAuthentication(true)
 *                 .login("bob@contoso.com")
 *                 .principalType("User")
 *                 .sid("00000011-1111-2222-2222-123456789111")
 *                 .tenantId("00000011-1111-2222-2222-123456789111")
 *                 .build())
 *             .location("Japan East")
 *             .publicNetworkAccess("Enabled")
 *             .resourceGroupName("sqlcrudtest-7398")
 *             .restrictOutboundNetworkAccess("Enabled")
 *             .serverName("sqlcrudtest-4645")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:Server sqlcrudtest-4645 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}
 * ```
 * @property administratorLogin Administrator username for the server. Once created it cannot be changed.
 * @property administratorLoginPassword The administrator login password (required for server creation).
 * @property administrators The Azure Active Directory administrator of the server.
 * @property federatedClientId The Client id used for cross tenant CMK scenario
 * @property identity The Azure Active Directory identity of the server.
 * @property keyId A CMK URI of the key to use for encryption.
 * @property location Resource location.
 * @property minimalTlsVersion Minimal TLS version. Allowed values: '1.0', '1.1', '1.2'
 * @property primaryUserAssignedIdentityId The resource id of a user assigned identity to be used by default.
 * @property publicNetworkAccess Whether or not public endpoint access is allowed for this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property restrictOutboundNetworkAccess Whether or not to restrict outbound network access for this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
 * @property serverName The name of the server.
 * @property tags Resource tags.
 * @property version The version of the server.
 */
public data class ServerArgs(
    public val administratorLogin: Output<String>? = null,
    public val administratorLoginPassword: Output<String>? = null,
    public val administrators: Output<ServerExternalAdministratorArgs>? = null,
    public val federatedClientId: Output<String>? = null,
    public val identity: Output<ResourceIdentityArgs>? = null,
    public val keyId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val minimalTlsVersion: Output<String>? = null,
    public val primaryUserAssignedIdentityId: Output<String>? = null,
    public val publicNetworkAccess: Output<Either<String, ServerNetworkAccessFlag>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val restrictOutboundNetworkAccess: Output<Either<String, ServerNetworkAccessFlag>>? = null,
    public val serverName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.ServerArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.ServerArgs =
        com.pulumi.azurenative.sql.ServerArgs.builder()
            .administratorLogin(administratorLogin?.applyValue({ args0 -> args0 }))
            .administratorLoginPassword(administratorLoginPassword?.applyValue({ args0 -> args0 }))
            .administrators(administrators?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .federatedClientId(federatedClientId?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyId(keyId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .minimalTlsVersion(minimalTlsVersion?.applyValue({ args0 -> args0 }))
            .primaryUserAssignedIdentityId(primaryUserAssignedIdentityId?.applyValue({ args0 -> args0 }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .restrictOutboundNetworkAccess(
                restrictOutboundNetworkAccess?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerArgs].
 */
@PulumiTagMarker
public class ServerArgsBuilder internal constructor() {
    private var administratorLogin: Output<String>? = null

    private var administratorLoginPassword: Output<String>? = null

    private var administrators: Output<ServerExternalAdministratorArgs>? = null

    private var federatedClientId: Output<String>? = null

    private var identity: Output<ResourceIdentityArgs>? = null

    private var keyId: Output<String>? = null

    private var location: Output<String>? = null

    private var minimalTlsVersion: Output<String>? = null

    private var primaryUserAssignedIdentityId: Output<String>? = null

    private var publicNetworkAccess: Output<Either<String, ServerNetworkAccessFlag>>? = null

    private var resourceGroupName: Output<String>? = null

    private var restrictOutboundNetworkAccess: Output<Either<String, ServerNetworkAccessFlag>>? = null

    private var serverName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var version: Output<String>? = null

    /**
     * @param value Administrator username for the server. Once created it cannot be changed.
     */
    @JvmName("siqcfwkxeqloaveh")
    public suspend fun administratorLogin(`value`: Output<String>) {
        this.administratorLogin = value
    }

    /**
     * @param value The administrator login password (required for server creation).
     */
    @JvmName("lbenuuygtubrlvyr")
    public suspend fun administratorLoginPassword(`value`: Output<String>) {
        this.administratorLoginPassword = value
    }

    /**
     * @param value The Azure Active Directory administrator of the server.
     */
    @JvmName("yebidwtbwhprwllj")
    public suspend fun administrators(`value`: Output<ServerExternalAdministratorArgs>) {
        this.administrators = value
    }

    /**
     * @param value The Client id used for cross tenant CMK scenario
     */
    @JvmName("pengrwxgwerrfjlm")
    public suspend fun federatedClientId(`value`: Output<String>) {
        this.federatedClientId = value
    }

    /**
     * @param value The Azure Active Directory identity of the server.
     */
    @JvmName("jbsrirligutdhiyw")
    public suspend fun identity(`value`: Output<ResourceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value A CMK URI of the key to use for encryption.
     */
    @JvmName("ridtkunvlfoxqtqg")
    public suspend fun keyId(`value`: Output<String>) {
        this.keyId = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("iwyvcbopdmohqahy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Minimal TLS version. Allowed values: '1.0', '1.1', '1.2'
     */
    @JvmName("guitunpeiiaspbre")
    public suspend fun minimalTlsVersion(`value`: Output<String>) {
        this.minimalTlsVersion = value
    }

    /**
     * @param value The resource id of a user assigned identity to be used by default.
     */
    @JvmName("dhqmwkvnwiisdwia")
    public suspend fun primaryUserAssignedIdentityId(`value`: Output<String>) {
        this.primaryUserAssignedIdentityId = value
    }

    /**
     * @param value Whether or not public endpoint access is allowed for this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    @JvmName("mdqdsdekbaouhlid")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, ServerNetworkAccessFlag>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("jmaxrkgdgrsgmysq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Whether or not to restrict outbound network access for this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    @JvmName("otvtogsxtxetquan")
    public suspend fun restrictOutboundNetworkAccess(`value`: Output<Either<String, ServerNetworkAccessFlag>>) {
        this.restrictOutboundNetworkAccess = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("dpxjfilwnpbutjka")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jqcwwsrccmbfcbfh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The version of the server.
     */
    @JvmName("tshsuleqixwglyyx")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Administrator username for the server. Once created it cannot be changed.
     */
    @JvmName("hadbpqwcctbttvce")
    public suspend fun administratorLogin(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorLogin = mapped
    }

    /**
     * @param value The administrator login password (required for server creation).
     */
    @JvmName("ffufgpakpjwpvjor")
    public suspend fun administratorLoginPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorLoginPassword = mapped
    }

    /**
     * @param value The Azure Active Directory administrator of the server.
     */
    @JvmName("kluavqxgvdmweiuy")
    public suspend fun administrators(`value`: ServerExternalAdministratorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administrators = mapped
    }

    /**
     * @param argument The Azure Active Directory administrator of the server.
     */
    @JvmName("cjasjyslunmluqee")
    public suspend fun administrators(argument: suspend ServerExternalAdministratorArgsBuilder.() -> Unit) {
        val toBeMapped = ServerExternalAdministratorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.administrators = mapped
    }

    /**
     * @param value The Client id used for cross tenant CMK scenario
     */
    @JvmName("qsooegsqmghhkemr")
    public suspend fun federatedClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.federatedClientId = mapped
    }

    /**
     * @param value The Azure Active Directory identity of the server.
     */
    @JvmName("vxbbjupwwenbbina")
    public suspend fun identity(`value`: ResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The Azure Active Directory identity of the server.
     */
    @JvmName("efufkovbgojcfliu")
    public suspend fun identity(argument: suspend ResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value A CMK URI of the key to use for encryption.
     */
    @JvmName("mccgvejcujebmhfq")
    public suspend fun keyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyId = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("hocmqibkukljksyl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Minimal TLS version. Allowed values: '1.0', '1.1', '1.2'
     */
    @JvmName("hnequlwldikthoql")
    public suspend fun minimalTlsVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimalTlsVersion = mapped
    }

    /**
     * @param value The resource id of a user assigned identity to be used by default.
     */
    @JvmName("fnpxdhkpqytulafg")
    public suspend fun primaryUserAssignedIdentityId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryUserAssignedIdentityId = mapped
    }

    /**
     * @param value Whether or not public endpoint access is allowed for this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    @JvmName("atlhqfgrtyrinwuk")
    public suspend fun publicNetworkAccess(`value`: Either<String, ServerNetworkAccessFlag>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public endpoint access is allowed for this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    @JvmName("nnhyunqnnjxhfkyp")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServerNetworkAccessFlag>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public endpoint access is allowed for this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    @JvmName("uqjwflrlrycuymbu")
    public fun publicNetworkAccess(`value`: ServerNetworkAccessFlag) {
        val toBeMapped = Either.ofRight<String, ServerNetworkAccessFlag>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("xdmigrwkwlwjndwk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Whether or not to restrict outbound network access for this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    @JvmName("gqdagcnlbroksgwy")
    public suspend fun restrictOutboundNetworkAccess(`value`: Either<String, ServerNetworkAccessFlag>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restrictOutboundNetworkAccess = mapped
    }

    /**
     * @param value Whether or not to restrict outbound network access for this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    @JvmName("yyvbppwwbjjvtcwe")
    public fun restrictOutboundNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServerNetworkAccessFlag>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.restrictOutboundNetworkAccess = mapped
    }

    /**
     * @param value Whether or not to restrict outbound network access for this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    @JvmName("kgfjkikykptyaptp")
    public fun restrictOutboundNetworkAccess(`value`: ServerNetworkAccessFlag) {
        val toBeMapped = Either.ofRight<String, ServerNetworkAccessFlag>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.restrictOutboundNetworkAccess = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("qktdysrmilpisxym")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wyeqxgpswjwfdlyb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jlmdeeutndgebofi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The version of the server.
     */
    @JvmName("rjhlbdbbttdmcynl")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ServerArgs = ServerArgs(
        administratorLogin = administratorLogin,
        administratorLoginPassword = administratorLoginPassword,
        administrators = administrators,
        federatedClientId = federatedClientId,
        identity = identity,
        keyId = keyId,
        location = location,
        minimalTlsVersion = minimalTlsVersion,
        primaryUserAssignedIdentityId = primaryUserAssignedIdentityId,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        restrictOutboundNetworkAccess = restrictOutboundNetworkAccess,
        serverName = serverName,
        tags = tags,
        version = version,
    )
}
