@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServerAzureADAdministrator].
 */
@PulumiTagMarker
public class ServerAzureADAdministratorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerAzureADAdministratorArgs = ServerAzureADAdministratorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerAzureADAdministratorArgsBuilder.() -> Unit) {
        val builder = ServerAzureADAdministratorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerAzureADAdministrator {
        val builtJavaResource =
            com.pulumi.azurenative.sql.ServerAzureADAdministrator(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServerAzureADAdministrator(builtJavaResource)
    }
}

/**
 * Azure Active Directory administrator.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2014-04-01, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Creates or updates an existing Azure Active Directory administrator.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverAzureADAdministrator = new AzureNative.Sql.ServerAzureADAdministrator("serverAzureADAdministrator", new()
 *     {
 *         AdministratorName = "ActiveDirectory",
 *         AdministratorType = AzureNative.Sql.AdministratorType.ActiveDirectory,
 *         Login = "bob@contoso.com",
 *         ResourceGroupName = "sqlcrudtest-4799",
 *         ServerName = "sqlcrudtest-6440",
 *         Sid = "c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c",
 *         TenantId = "c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewServerAzureADAdministrator(ctx, "serverAzureADAdministrator", &sql.ServerAzureADAdministratorArgs{
 * 			AdministratorName: pulumi.String("ActiveDirectory"),
 * 			AdministratorType: pulumi.String(sql.AdministratorTypeActiveDirectory),
 * 			Login:             pulumi.String("bob@contoso.com"),
 * 			ResourceGroupName: pulumi.String("sqlcrudtest-4799"),
 * 			ServerName:        pulumi.String("sqlcrudtest-6440"),
 * 			Sid:               pulumi.String("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c"),
 * 			TenantId:          pulumi.String("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ServerAzureADAdministrator;
 * import com.pulumi.azurenative.sql.ServerAzureADAdministratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverAzureADAdministrator = new ServerAzureADAdministrator("serverAzureADAdministrator", ServerAzureADAdministratorArgs.builder()
 *             .administratorName("ActiveDirectory")
 *             .administratorType("ActiveDirectory")
 *             .login("bob@contoso.com")
 *             .resourceGroupName("sqlcrudtest-4799")
 *             .serverName("sqlcrudtest-6440")
 *             .sid("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c")
 *             .tenantId("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ServerAzureADAdministrator ActiveDirectory /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/administrators/{administratorName}
 * ```
 */
public class ServerAzureADAdministrator internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.ServerAzureADAdministrator,
) : KotlinCustomResource(javaResource, ServerAzureADAdministratorMapper) {
    /**
     * Type of the sever administrator.
     */
    public val administratorType: Output<String>
        get() = javaResource.administratorType().applyValue({ args0 -> args0 })

    /**
     * Azure Active Directory only Authentication enabled.
     */
    public val azureADOnlyAuthentication: Output<Boolean>
        get() = javaResource.azureADOnlyAuthentication().applyValue({ args0 -> args0 })

    /**
     * Login name of the server administrator.
     */
    public val login: Output<String>
        get() = javaResource.login().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * SID (object ID) of the server administrator.
     */
    public val sid: Output<String>
        get() = javaResource.sid().applyValue({ args0 -> args0 })

    /**
     * Tenant ID of the administrator.
     */
    public val tenantId: Output<String>?
        get() = javaResource.tenantId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServerAzureADAdministratorMapper : ResourceMapper<ServerAzureADAdministrator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.ServerAzureADAdministrator::class == javaResource::class

    override fun map(javaResource: Resource): ServerAzureADAdministrator =
        ServerAzureADAdministrator(
            javaResource as
                com.pulumi.azurenative.sql.ServerAzureADAdministrator,
        )
}

/**
 * @see [ServerAzureADAdministrator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerAzureADAdministrator].
 */
public suspend fun serverAzureADAdministrator(
    name: String,
    block: suspend ServerAzureADAdministratorResourceBuilder.() -> Unit,
): ServerAzureADAdministrator {
    val builder = ServerAzureADAdministratorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerAzureADAdministrator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverAzureADAdministrator(name: String): ServerAzureADAdministrator {
    val builder = ServerAzureADAdministratorResourceBuilder()
    builder.name(name)
    return builder.build()
}
