@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServerCommunicationLink].
 */
@PulumiTagMarker
public class ServerCommunicationLinkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerCommunicationLinkArgs = ServerCommunicationLinkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerCommunicationLinkArgsBuilder.() -> Unit) {
        val builder = ServerCommunicationLinkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerCommunicationLink {
        val builtJavaResource =
            com.pulumi.azurenative.sql.ServerCommunicationLink(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServerCommunicationLink(builtJavaResource)
    }
}

/**
 * Server communication link.
 * Azure REST API version: 2014-04-01. Prior API version in Azure Native 1.x: 2014-04-01.
 * ## Example Usage
 * ### Create a server communication link
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverCommunicationLink = new AzureNative.Sql.ServerCommunicationLink("serverCommunicationLink", new()
 *     {
 *         CommunicationLinkName = "link1",
 *         PartnerServer = "sqldcrudtest-test",
 *         ResourceGroupName = "sqlcrudtest-7398",
 *         ServerName = "sqlcrudtest-4645",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewServerCommunicationLink(ctx, "serverCommunicationLink", &sql.ServerCommunicationLinkArgs{
 * 			CommunicationLinkName: pulumi.String("link1"),
 * 			PartnerServer:         pulumi.String("sqldcrudtest-test"),
 * 			ResourceGroupName:     pulumi.String("sqlcrudtest-7398"),
 * 			ServerName:            pulumi.String("sqlcrudtest-4645"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ServerCommunicationLink;
 * import com.pulumi.azurenative.sql.ServerCommunicationLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverCommunicationLink = new ServerCommunicationLink("serverCommunicationLink", ServerCommunicationLinkArgs.builder()
 *             .communicationLinkName("link1")
 *             .partnerServer("sqldcrudtest-test")
 *             .resourceGroupName("sqlcrudtest-7398")
 *             .serverName("sqlcrudtest-4645")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ServerCommunicationLink link1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/communicationLinks/{communicationLinkName}
 * ```
 */
public class ServerCommunicationLink internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.ServerCommunicationLink,
) : KotlinCustomResource(javaResource, ServerCommunicationLinkMapper) {
    /**
     * Communication link kind.  This property is used for Azure Portal metadata.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Communication link location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name of the partner server.
     */
    public val partnerServer: Output<String>
        get() = javaResource.partnerServer().applyValue({ args0 -> args0 })

    /**
     * The state.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServerCommunicationLinkMapper : ResourceMapper<ServerCommunicationLink> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.ServerCommunicationLink::class == javaResource::class

    override fun map(javaResource: Resource): ServerCommunicationLink =
        ServerCommunicationLink(javaResource as com.pulumi.azurenative.sql.ServerCommunicationLink)
}

/**
 * @see [ServerCommunicationLink].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerCommunicationLink].
 */
public suspend fun serverCommunicationLink(
    name: String,
    block: suspend ServerCommunicationLinkResourceBuilder.() -> Unit,
): ServerCommunicationLink {
    val builder = ServerCommunicationLinkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerCommunicationLink].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverCommunicationLink(name: String): ServerCommunicationLink {
    val builder = ServerCommunicationLinkResourceBuilder()
    builder.name(name)
    return builder.build()
}
