@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServerDnsAlias].
 */
@PulumiTagMarker
public class ServerDnsAliasResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerDnsAliasArgs = ServerDnsAliasArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerDnsAliasArgsBuilder.() -> Unit) {
        val builder = ServerDnsAliasArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerDnsAlias {
        val builtJavaResource = com.pulumi.azurenative.sql.ServerDnsAlias(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServerDnsAlias(builtJavaResource)
    }
}

/**
 * A server DNS alias.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create server DNS alias
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverDnsAlias = new AzureNative.Sql.ServerDnsAlias("serverDnsAlias", new()
 *     {
 *         DnsAliasName = "dns-alias-name-1",
 *         ResourceGroupName = "Default",
 *         ServerName = "dns-alias-server",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewServerDnsAlias(ctx, "serverDnsAlias", &sql.ServerDnsAliasArgs{
 * 			DnsAliasName:      pulumi.String("dns-alias-name-1"),
 * 			ResourceGroupName: pulumi.String("Default"),
 * 			ServerName:        pulumi.String("dns-alias-server"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ServerDnsAlias;
 * import com.pulumi.azurenative.sql.ServerDnsAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverDnsAlias = new ServerDnsAlias("serverDnsAlias", ServerDnsAliasArgs.builder()
 *             .dnsAliasName("dns-alias-name-1")
 *             .resourceGroupName("Default")
 *             .serverName("dns-alias-server")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ServerDnsAlias dns-alias-name-1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases/{dnsAliasName}
 * ```
 */
public class ServerDnsAlias internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.ServerDnsAlias,
) : KotlinCustomResource(javaResource, ServerDnsAliasMapper) {
    /**
     * The fully qualified DNS record for alias
     */
    public val azureDnsRecord: Output<String>
        get() = javaResource.azureDnsRecord().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServerDnsAliasMapper : ResourceMapper<ServerDnsAlias> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.ServerDnsAlias::class == javaResource::class

    override fun map(javaResource: Resource): ServerDnsAlias = ServerDnsAlias(
        javaResource as
            com.pulumi.azurenative.sql.ServerDnsAlias,
    )
}

/**
 * @see [ServerDnsAlias].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerDnsAlias].
 */
public suspend fun serverDnsAlias(
    name: String,
    block: suspend ServerDnsAliasResourceBuilder.() -> Unit,
): ServerDnsAlias {
    val builder = ServerDnsAliasResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerDnsAlias].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverDnsAlias(name: String): ServerDnsAlias {
    val builder = ServerDnsAliasResourceBuilder()
    builder.name(name)
    return builder.build()
}
