@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ServerDnsAliasArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A server DNS alias.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create server DNS alias
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverDnsAlias = new AzureNative.Sql.ServerDnsAlias("serverDnsAlias", new()
 *     {
 *         DnsAliasName = "dns-alias-name-1",
 *         ResourceGroupName = "Default",
 *         ServerName = "dns-alias-server",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewServerDnsAlias(ctx, "serverDnsAlias", &sql.ServerDnsAliasArgs{
 * 			DnsAliasName:      pulumi.String("dns-alias-name-1"),
 * 			ResourceGroupName: pulumi.String("Default"),
 * 			ServerName:        pulumi.String("dns-alias-server"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ServerDnsAlias;
 * import com.pulumi.azurenative.sql.ServerDnsAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverDnsAlias = new ServerDnsAlias("serverDnsAlias", ServerDnsAliasArgs.builder()
 *             .dnsAliasName("dns-alias-name-1")
 *             .resourceGroupName("Default")
 *             .serverName("dns-alias-server")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ServerDnsAlias dns-alias-name-1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/dnsAliases/{dnsAliasName}
 * ```
 * @property dnsAliasName The name of the server dns alias.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server that the alias is pointing to.
 */
public data class ServerDnsAliasArgs(
    public val dnsAliasName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.ServerDnsAliasArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.ServerDnsAliasArgs =
        com.pulumi.azurenative.sql.ServerDnsAliasArgs.builder()
            .dnsAliasName(dnsAliasName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerDnsAliasArgs].
 */
@PulumiTagMarker
public class ServerDnsAliasArgsBuilder internal constructor() {
    private var dnsAliasName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    /**
     * @param value The name of the server dns alias.
     */
    @JvmName("hwfptsldromuialb")
    public suspend fun dnsAliasName(`value`: Output<String>) {
        this.dnsAliasName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ebyiefdhoclqpfkb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server that the alias is pointing to.
     */
    @JvmName("jqbxsahcfcnxkglb")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The name of the server dns alias.
     */
    @JvmName("puviwboibkwbfmbp")
    public suspend fun dnsAliasName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsAliasName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("tastncaooyminrpf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server that the alias is pointing to.
     */
    @JvmName("xrdbxgqhnbnysvtt")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    internal fun build(): ServerDnsAliasArgs = ServerDnsAliasArgs(
        dnsAliasName = dnsAliasName,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
    )
}
