@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServerKey].
 */
@PulumiTagMarker
public class ServerKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerKeyArgs = ServerKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerKeyArgsBuilder.() -> Unit) {
        val builder = ServerKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerKey {
        val builtJavaResource = com.pulumi.azurenative.sql.ServerKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServerKey(builtJavaResource)
    }
}

/**
 * A server key.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2015-05-01-preview, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Creates or updates a server key
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverKey = new AzureNative.Sql.ServerKey("serverKey", new()
 *     {
 *         KeyName = "someVault_someKey_01234567890123456789012345678901",
 *         ResourceGroupName = "sqlcrudtest-7398",
 *         ServerKeyType = AzureNative.Sql.ServerKeyType.AzureKeyVault,
 *         ServerName = "sqlcrudtest-4645",
 *         Uri = "https://someVault.vault.azure.net/keys/someKey/01234567890123456789012345678901",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewServerKey(ctx, "serverKey", &sql.ServerKeyArgs{
 * 			KeyName:           pulumi.String("someVault_someKey_01234567890123456789012345678901"),
 * 			ResourceGroupName: pulumi.String("sqlcrudtest-7398"),
 * 			ServerKeyType:     pulumi.String(sql.ServerKeyTypeAzureKeyVault),
 * 			ServerName:        pulumi.String("sqlcrudtest-4645"),
 * 			Uri:               pulumi.String("https://someVault.vault.azure.net/keys/someKey/01234567890123456789012345678901"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ServerKey;
 * import com.pulumi.azurenative.sql.ServerKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverKey = new ServerKey("serverKey", ServerKeyArgs.builder()
 *             .keyName("someVault_someKey_01234567890123456789012345678901")
 *             .resourceGroupName("sqlcrudtest-7398")
 *             .serverKeyType("AzureKeyVault")
 *             .serverName("sqlcrudtest-4645")
 *             .uri("https://someVault.vault.azure.net/keys/someKey/01234567890123456789012345678901")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ServerKey sqlcrudtest-4645 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/keys/{keyName}
 * ```
 */
public class ServerKey internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.ServerKey,
) : KotlinCustomResource(javaResource, ServerKeyMapper) {
    /**
     * Key auto rotation opt-in flag. Either true or false.
     */
    public val autoRotationEnabled: Output<Boolean>
        get() = javaResource.autoRotationEnabled().applyValue({ args0 -> args0 })

    /**
     * The server key creation date.
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * Kind of encryption protector. This is metadata used for the Azure portal experience.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Subregion of the server key.
     */
    public val subregion: Output<String>
        get() = javaResource.subregion().applyValue({ args0 -> args0 })

    /**
     * Thumbprint of the server key.
     */
    public val thumbprint: Output<String>
        get() = javaResource.thumbprint().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServerKeyMapper : ResourceMapper<ServerKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.ServerKey::class == javaResource::class

    override fun map(javaResource: Resource): ServerKey = ServerKey(
        javaResource as
            com.pulumi.azurenative.sql.ServerKey,
    )
}

/**
 * @see [ServerKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerKey].
 */
public suspend fun serverKey(name: String, block: suspend ServerKeyResourceBuilder.() -> Unit): ServerKey {
    val builder = ServerKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverKey(name: String): ServerKey {
    val builder = ServerKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
