@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ServerTrustCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Server trust certificate imported from box to enable connection between box and Sql Managed Instance.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2021-05-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create server trust certificate.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverTrustCertificate = new AzureNative.Sql.ServerTrustCertificate("serverTrustCertificate", new()
 *     {
 *         CertificateName = "customerCertificateName",
 *         ManagedInstanceName = "testcl",
 *         PublicBlob = "308203AE30820296A0030201020210",
 *         ResourceGroupName = "testrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewServerTrustCertificate(ctx, "serverTrustCertificate", &sql.ServerTrustCertificateArgs{
 * 			CertificateName:     pulumi.String("customerCertificateName"),
 * 			ManagedInstanceName: pulumi.String("testcl"),
 * 			PublicBlob:          pulumi.String("308203AE30820296A0030201020210"),
 * 			ResourceGroupName:   pulumi.String("testrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ServerTrustCertificate;
 * import com.pulumi.azurenative.sql.ServerTrustCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverTrustCertificate = new ServerTrustCertificate("serverTrustCertificate", ServerTrustCertificateArgs.builder()
 *             .certificateName("customerCertificateName")
 *             .managedInstanceName("testcl")
 *             .publicBlob("308203AE30820296A0030201020210")
 *             .resourceGroupName("testrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ServerTrustCertificate customerCertificateName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/serverTrustCertificates/{certificateName}
 * ```
 * @property certificateName Name of of the certificate to upload.
 * @property managedInstanceName The name of the managed instance.
 * @property publicBlob The certificate public blob
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 */
public data class ServerTrustCertificateArgs(
    public val certificateName: Output<String>? = null,
    public val managedInstanceName: Output<String>? = null,
    public val publicBlob: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.ServerTrustCertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.ServerTrustCertificateArgs =
        com.pulumi.azurenative.sql.ServerTrustCertificateArgs.builder()
            .certificateName(certificateName?.applyValue({ args0 -> args0 }))
            .managedInstanceName(managedInstanceName?.applyValue({ args0 -> args0 }))
            .publicBlob(publicBlob?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerTrustCertificateArgs].
 */
@PulumiTagMarker
public class ServerTrustCertificateArgsBuilder internal constructor() {
    private var certificateName: Output<String>? = null

    private var managedInstanceName: Output<String>? = null

    private var publicBlob: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of of the certificate to upload.
     */
    @JvmName("xmpystmtqgfbvbxv")
    public suspend fun certificateName(`value`: Output<String>) {
        this.certificateName = value
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("klcmhmuvxfiatydp")
    public suspend fun managedInstanceName(`value`: Output<String>) {
        this.managedInstanceName = value
    }

    /**
     * @param value The certificate public blob
     */
    @JvmName("dofonkkrkkboaptl")
    public suspend fun publicBlob(`value`: Output<String>) {
        this.publicBlob = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("yhiubknvyetfgheg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of of the certificate to upload.
     */
    @JvmName("kvjkmwdvednygwmo")
    public suspend fun certificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateName = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("ruwofqpjoomiuhoi")
    public suspend fun managedInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The certificate public blob
     */
    @JvmName("tfjhluoiskofxbil")
    public suspend fun publicBlob(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicBlob = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("mncetxjvgdfggvrj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ServerTrustCertificateArgs = ServerTrustCertificateArgs(
        certificateName = certificateName,
        managedInstanceName = managedInstanceName,
        publicBlob = publicBlob,
        resourceGroupName = resourceGroupName,
    )
}
