@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.kotlin.outputs.ServerInfoResponse
import com.pulumi.azurenative.sql.kotlin.outputs.ServerInfoResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ServerTrustGroup].
 */
@PulumiTagMarker
public class ServerTrustGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerTrustGroupArgs = ServerTrustGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerTrustGroupArgsBuilder.() -> Unit) {
        val builder = ServerTrustGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerTrustGroup {
        val builtJavaResource = com.pulumi.azurenative.sql.ServerTrustGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServerTrustGroup(builtJavaResource)
    }
}

/**
 * A server trust group.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create server trust group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverTrustGroup = new AzureNative.Sql.ServerTrustGroup("serverTrustGroup", new()
 *     {
 *         GroupMembers = new[]
 *         {
 *             new AzureNative.Sql.Inputs.ServerInfoArgs
 *             {
 *                 ServerId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/managedInstance-1",
 *             },
 *             new AzureNative.Sql.Inputs.ServerInfoArgs
 *             {
 *                 ServerId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/managedInstance-2",
 *             },
 *         },
 *         LocationName = "Japan East",
 *         ResourceGroupName = "Default",
 *         ServerTrustGroupName = "server-trust-group-test",
 *         TrustScopes = new[]
 *         {
 *             "GlobalTransactions",
 *             "ServiceBroker",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewServerTrustGroup(ctx, "serverTrustGroup", &sql.ServerTrustGroupArgs{
 * 			GroupMembers: sql.ServerInfoArray{
 * 				&sql.ServerInfoArgs{
 * 					ServerId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/managedInstance-1"),
 * 				},
 * 				&sql.ServerInfoArgs{
 * 					ServerId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/managedInstance-2"),
 * 				},
 * 			},
 * 			LocationName:         pulumi.String("Japan East"),
 * 			ResourceGroupName:    pulumi.String("Default"),
 * 			ServerTrustGroupName: pulumi.String("server-trust-group-test"),
 * 			TrustScopes: pulumi.StringArray{
 * 				pulumi.String("GlobalTransactions"),
 * 				pulumi.String("ServiceBroker"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ServerTrustGroup;
 * import com.pulumi.azurenative.sql.ServerTrustGroupArgs;
 * import com.pulumi.azurenative.sql.inputs.ServerInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverTrustGroup = new ServerTrustGroup("serverTrustGroup", ServerTrustGroupArgs.builder()
 *             .groupMembers(
 *                 ServerInfoArgs.builder()
 *                     .serverId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/managedInstance-1")
 *                     .build(),
 *                 ServerInfoArgs.builder()
 *                     .serverId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/managedInstance-2")
 *                     .build())
 *             .locationName("Japan East")
 *             .resourceGroupName("Default")
 *             .serverTrustGroupName("server-trust-group-test")
 *             .trustScopes(
 *                 "GlobalTransactions",
 *                 "ServiceBroker")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ServerTrustGroup server-trust-group-test /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/serverTrustGroups/{serverTrustGroupName}
 * ```
 */
public class ServerTrustGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.ServerTrustGroup,
) : KotlinCustomResource(javaResource, ServerTrustGroupMapper) {
    /**
     * Group members information for the server trust group.
     */
    public val groupMembers: Output<List<ServerInfoResponse>>
        get() = javaResource.groupMembers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Trust scope of the server trust group.
     */
    public val trustScopes: Output<List<String>>
        get() = javaResource.trustScopes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServerTrustGroupMapper : ResourceMapper<ServerTrustGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.ServerTrustGroup::class == javaResource::class

    override fun map(javaResource: Resource): ServerTrustGroup = ServerTrustGroup(
        javaResource as
            com.pulumi.azurenative.sql.ServerTrustGroup,
    )
}

/**
 * @see [ServerTrustGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerTrustGroup].
 */
public suspend fun serverTrustGroup(
    name: String,
    block: suspend ServerTrustGroupResourceBuilder.() -> Unit,
): ServerTrustGroup {
    val builder = ServerTrustGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerTrustGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverTrustGroup(name: String): ServerTrustGroup {
    val builder = ServerTrustGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
