@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ServerTrustGroupArgs.builder
import com.pulumi.azurenative.sql.kotlin.inputs.ServerInfoArgs
import com.pulumi.azurenative.sql.kotlin.inputs.ServerInfoArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A server trust group.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create server trust group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverTrustGroup = new AzureNative.Sql.ServerTrustGroup("serverTrustGroup", new()
 *     {
 *         GroupMembers = new[]
 *         {
 *             new AzureNative.Sql.Inputs.ServerInfoArgs
 *             {
 *                 ServerId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/managedInstance-1",
 *             },
 *             new AzureNative.Sql.Inputs.ServerInfoArgs
 *             {
 *                 ServerId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/managedInstance-2",
 *             },
 *         },
 *         LocationName = "Japan East",
 *         ResourceGroupName = "Default",
 *         ServerTrustGroupName = "server-trust-group-test",
 *         TrustScopes = new[]
 *         {
 *             "GlobalTransactions",
 *             "ServiceBroker",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewServerTrustGroup(ctx, "serverTrustGroup", &sql.ServerTrustGroupArgs{
 * 			GroupMembers: sql.ServerInfoArray{
 * 				&sql.ServerInfoArgs{
 * 					ServerId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/managedInstance-1"),
 * 				},
 * 				&sql.ServerInfoArgs{
 * 					ServerId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/managedInstance-2"),
 * 				},
 * 			},
 * 			LocationName:         pulumi.String("Japan East"),
 * 			ResourceGroupName:    pulumi.String("Default"),
 * 			ServerTrustGroupName: pulumi.String("server-trust-group-test"),
 * 			TrustScopes: pulumi.StringArray{
 * 				pulumi.String("GlobalTransactions"),
 * 				pulumi.String("ServiceBroker"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ServerTrustGroup;
 * import com.pulumi.azurenative.sql.ServerTrustGroupArgs;
 * import com.pulumi.azurenative.sql.inputs.ServerInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverTrustGroup = new ServerTrustGroup("serverTrustGroup", ServerTrustGroupArgs.builder()
 *             .groupMembers(
 *                 ServerInfoArgs.builder()
 *                     .serverId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/managedInstance-1")
 *                     .build(),
 *                 ServerInfoArgs.builder()
 *                     .serverId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/managedInstances/managedInstance-2")
 *                     .build())
 *             .locationName("Japan East")
 *             .resourceGroupName("Default")
 *             .serverTrustGroupName("server-trust-group-test")
 *             .trustScopes(
 *                 "GlobalTransactions",
 *                 "ServiceBroker")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ServerTrustGroup server-trust-group-test /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/serverTrustGroups/{serverTrustGroupName}
 * ```
 * @property groupMembers Group members information for the server trust group.
 * @property locationName The name of the region where the resource is located.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverTrustGroupName The name of the server trust group.
 * @property trustScopes Trust scope of the server trust group.
 */
public data class ServerTrustGroupArgs(
    public val groupMembers: Output<List<ServerInfoArgs>>? = null,
    public val locationName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverTrustGroupName: Output<String>? = null,
    public val trustScopes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.ServerTrustGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.ServerTrustGroupArgs =
        com.pulumi.azurenative.sql.ServerTrustGroupArgs.builder()
            .groupMembers(
                groupMembers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .locationName(locationName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverTrustGroupName(serverTrustGroupName?.applyValue({ args0 -> args0 }))
            .trustScopes(trustScopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ServerTrustGroupArgs].
 */
@PulumiTagMarker
public class ServerTrustGroupArgsBuilder internal constructor() {
    private var groupMembers: Output<List<ServerInfoArgs>>? = null

    private var locationName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverTrustGroupName: Output<String>? = null

    private var trustScopes: Output<List<String>>? = null

    /**
     * @param value Group members information for the server trust group.
     */
    @JvmName("ngirxgqdtqlluoag")
    public suspend fun groupMembers(`value`: Output<List<ServerInfoArgs>>) {
        this.groupMembers = value
    }

    @JvmName("kyesoadmkilcfgsf")
    public suspend fun groupMembers(vararg values: Output<ServerInfoArgs>) {
        this.groupMembers = Output.all(values.asList())
    }

    /**
     * @param values Group members information for the server trust group.
     */
    @JvmName("unyixngoupdciynn")
    public suspend fun groupMembers(values: List<Output<ServerInfoArgs>>) {
        this.groupMembers = Output.all(values)
    }

    /**
     * @param value The name of the region where the resource is located.
     */
    @JvmName("fnpdfujjukaxgbmc")
    public suspend fun locationName(`value`: Output<String>) {
        this.locationName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("tcevtbbtdfnujttd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server trust group.
     */
    @JvmName("nnfpuqaauclutiad")
    public suspend fun serverTrustGroupName(`value`: Output<String>) {
        this.serverTrustGroupName = value
    }

    /**
     * @param value Trust scope of the server trust group.
     */
    @JvmName("handwgyxchcsjaii")
    public suspend fun trustScopes(`value`: Output<List<String>>) {
        this.trustScopes = value
    }

    @JvmName("sfgulhrbsetggjki")
    public suspend fun trustScopes(vararg values: Output<String>) {
        this.trustScopes = Output.all(values.asList())
    }

    /**
     * @param values Trust scope of the server trust group.
     */
    @JvmName("hfbndokfvvddlbfk")
    public suspend fun trustScopes(values: List<Output<String>>) {
        this.trustScopes = Output.all(values)
    }

    /**
     * @param value Group members information for the server trust group.
     */
    @JvmName("cbthakhbdpxnkicw")
    public suspend fun groupMembers(`value`: List<ServerInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupMembers = mapped
    }

    /**
     * @param argument Group members information for the server trust group.
     */
    @JvmName("kyixcfqfpesvquvk")
    public suspend fun groupMembers(argument: List<suspend ServerInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ServerInfoArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.groupMembers = mapped
    }

    /**
     * @param argument Group members information for the server trust group.
     */
    @JvmName("pfalltaspmurfdla")
    public suspend fun groupMembers(vararg argument: suspend ServerInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ServerInfoArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.groupMembers = mapped
    }

    /**
     * @param argument Group members information for the server trust group.
     */
    @JvmName("vuracxfkxxqtovfk")
    public suspend fun groupMembers(argument: suspend ServerInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ServerInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.groupMembers = mapped
    }

    /**
     * @param values Group members information for the server trust group.
     */
    @JvmName("pamqqwbjjigbybku")
    public suspend fun groupMembers(vararg values: ServerInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupMembers = mapped
    }

    /**
     * @param value The name of the region where the resource is located.
     */
    @JvmName("yfquiystqmtqbdlh")
    public suspend fun locationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locationName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("quaptkvofbokdcxl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server trust group.
     */
    @JvmName("xyqlreobwxmkuuyi")
    public suspend fun serverTrustGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverTrustGroupName = mapped
    }

    /**
     * @param value Trust scope of the server trust group.
     */
    @JvmName("bmiwcumjhsftixje")
    public suspend fun trustScopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustScopes = mapped
    }

    /**
     * @param values Trust scope of the server trust group.
     */
    @JvmName("xcscfcixlflwtajc")
    public suspend fun trustScopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trustScopes = mapped
    }

    internal fun build(): ServerTrustGroupArgs = ServerTrustGroupArgs(
        groupMembers = groupMembers,
        locationName = locationName,
        resourceGroupName = resourceGroupName,
        serverTrustGroupName = serverTrustGroupName,
        trustScopes = trustScopes,
    )
}
