@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Collation of the metadata catalog.
 */
public enum class CatalogCollationType(
    public val javaValue: com.pulumi.azurenative.sql.enums.CatalogCollationType,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.CatalogCollationType> {
    DATABASE_DEFAULT(com.pulumi.azurenative.sql.enums.CatalogCollationType.DATABASE_DEFAULT),
    SQL_Latin1_General_CP1_CI_AS(com.pulumi.azurenative.sql.enums.CatalogCollationType.SQL_Latin1_General_CP1_CI_AS),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.CatalogCollationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.CatalogCollationType): CatalogCollationType = CatalogCollationType.values().first { it.javaValue == javaType }
    }
}
