@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The state of read-only routing. If enabled, connections that have application intent set to readonly in their connection string may be routed to a readonly secondary replica in the same region. Not applicable to a Hyperscale database within an elastic pool.
 */
public enum class DatabaseReadScale(
    public val javaValue: com.pulumi.azurenative.sql.enums.DatabaseReadScale,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.DatabaseReadScale> {
    Enabled(com.pulumi.azurenative.sql.enums.DatabaseReadScale.Enabled),
    Disabled(com.pulumi.azurenative.sql.enums.DatabaseReadScale.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.DatabaseReadScale = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.DatabaseReadScale): DatabaseReadScale = DatabaseReadScale.values().first { it.javaValue == javaType }
    }
}
