@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the mode of database creation.
 * Default: Regular instance creation.
 * Restore: Creates an instance by restoring a set of backups to specific point in time. RestorePointInTime and SourceManagedInstanceId must be specified.
 */
public enum class ManagedServerCreateMode(
    public val javaValue: com.pulumi.azurenative.sql.enums.ManagedServerCreateMode,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.ManagedServerCreateMode> {
    Default(com.pulumi.azurenative.sql.enums.ManagedServerCreateMode.Default),
    PointInTimeRestore(com.pulumi.azurenative.sql.enums.ManagedServerCreateMode.PointInTimeRestore),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.ManagedServerCreateMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.ManagedServerCreateMode): ManagedServerCreateMode =
            ManagedServerCreateMode.values().first { it.javaValue == javaType }
    }
}
