@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
 */
public enum class ReadWriteEndpointFailoverPolicy(
    public val javaValue: com.pulumi.azurenative.sql.enums.ReadWriteEndpointFailoverPolicy,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.ReadWriteEndpointFailoverPolicy> {
    Manual(com.pulumi.azurenative.sql.enums.ReadWriteEndpointFailoverPolicy.Manual),
    Automatic(com.pulumi.azurenative.sql.enums.ReadWriteEndpointFailoverPolicy.Automatic),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.ReadWriteEndpointFailoverPolicy =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.ReadWriteEndpointFailoverPolicy): ReadWriteEndpointFailoverPolicy =
            ReadWriteEndpointFailoverPolicy.values().first { it.javaValue == javaType }
    }
}
