@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The secondary type of the database if it is a secondary.  Valid values are Geo and Named.
 */
public enum class SecondaryType(
    public val javaValue: com.pulumi.azurenative.sql.enums.SecondaryType,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.SecondaryType> {
    Geo(com.pulumi.azurenative.sql.enums.SecondaryType.Geo),
    Named(com.pulumi.azurenative.sql.enums.SecondaryType.Named),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.SecondaryType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.SecondaryType): SecondaryType =
            SecondaryType.values().first { it.javaValue == javaType }
    }
}
