@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the state of the policy. If state is Enabled, storageEndpoint and storageAccountAccessKey are required.
 */
public enum class SecurityAlertPolicyState(
    public val javaValue: com.pulumi.azurenative.sql.enums.SecurityAlertPolicyState,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.SecurityAlertPolicyState> {
    New(com.pulumi.azurenative.sql.enums.SecurityAlertPolicyState.New),
    Enabled(com.pulumi.azurenative.sql.enums.SecurityAlertPolicyState.Enabled),
    Disabled(com.pulumi.azurenative.sql.enums.SecurityAlertPolicyState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.SecurityAlertPolicyState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.SecurityAlertPolicyState): SecurityAlertPolicyState =
            SecurityAlertPolicyState.values().first { it.javaValue == javaType }
    }
}
