@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the state of the SQL Vulnerability Assessment, whether it is enabled or disabled or a state has not been applied yet on the specific database or server.
 */
public enum class SqlVulnerabilityAssessmentState(
    public val javaValue: com.pulumi.azurenative.sql.enums.SqlVulnerabilityAssessmentState,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.SqlVulnerabilityAssessmentState> {
    Enabled(com.pulumi.azurenative.sql.enums.SqlVulnerabilityAssessmentState.Enabled),
    Disabled(com.pulumi.azurenative.sql.enums.SqlVulnerabilityAssessmentState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.SqlVulnerabilityAssessmentState =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.SqlVulnerabilityAssessmentState): SqlVulnerabilityAssessmentState =
            SqlVulnerabilityAssessmentState.values().first { it.javaValue == javaType }
    }
}
