@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Database type of the sync member.
 */
public enum class SyncMemberDbType(
    public val javaValue: com.pulumi.azurenative.sql.enums.SyncMemberDbType,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.SyncMemberDbType> {
    AzureSqlDatabase(com.pulumi.azurenative.sql.enums.SyncMemberDbType.AzureSqlDatabase),
    SqlServerDatabase(com.pulumi.azurenative.sql.enums.SyncMemberDbType.SqlServerDatabase),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.SyncMemberDbType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.SyncMemberDbType): SyncMemberDbType = SyncMemberDbType.values().first { it.javaValue == javaType }
    }
}
