@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetIPv6FirewallRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property firewallRuleName The name of the firewall rule.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class GetIPv6FirewallRulePlainArgs(
    public val firewallRuleName: String,
    public val resourceGroupName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetIPv6FirewallRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetIPv6FirewallRulePlainArgs =
        com.pulumi.azurenative.sql.inputs.GetIPv6FirewallRulePlainArgs.builder()
            .firewallRuleName(firewallRuleName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIPv6FirewallRulePlainArgs].
 */
@PulumiTagMarker
public class GetIPv6FirewallRulePlainArgsBuilder internal constructor() {
    private var firewallRuleName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of the firewall rule.
     */
    @JvmName("jmxhiofbddaxkxxq")
    public suspend fun firewallRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.firewallRuleName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("rvdgcpponjughoeg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("aekfkevwldwoxrup")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetIPv6FirewallRulePlainArgs = GetIPv6FirewallRulePlainArgs(
        firewallRuleName = firewallRuleName ?: throw PulumiNullFieldException("firewallRuleName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
    )
}
