@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetManagedInstancePrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managedInstanceName The name of the managed instance.
 * @property privateEndpointConnectionName The name of the private endpoint connection.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 */
public data class GetManagedInstancePrivateEndpointConnectionPlainArgs(
    public val managedInstanceName: String,
    public val privateEndpointConnectionName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetManagedInstancePrivateEndpointConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetManagedInstancePrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetManagedInstancePrivateEndpointConnectionPlainArgs.builder()
            .managedInstanceName(managedInstanceName.let({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedInstancePrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetManagedInstancePrivateEndpointConnectionPlainArgsBuilder internal constructor() {
    private var managedInstanceName: String? = null

    private var privateEndpointConnectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("kusdoewgftjsxleo")
    public suspend fun managedInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("htbljroieoryksmp")
    public suspend fun privateEndpointConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("elmktyihhdodstit")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagedInstancePrivateEndpointConnectionPlainArgs =
        GetManagedInstancePrivateEndpointConnectionPlainArgs(
            managedInstanceName = managedInstanceName ?: throw PulumiNullFieldException("managedInstanceName"),
            privateEndpointConnectionName = privateEndpointConnectionName ?: throw
                PulumiNullFieldException("privateEndpointConnectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
