@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetServerTrustGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property locationName The name of the region where the resource is located.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverTrustGroupName The name of the server trust group.
 */
public data class GetServerTrustGroupPlainArgs(
    public val locationName: String,
    public val resourceGroupName: String,
    public val serverTrustGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetServerTrustGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetServerTrustGroupPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetServerTrustGroupPlainArgs.builder()
            .locationName(locationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverTrustGroupName(serverTrustGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerTrustGroupPlainArgs].
 */
@PulumiTagMarker
public class GetServerTrustGroupPlainArgsBuilder internal constructor() {
    private var locationName: String? = null

    private var resourceGroupName: String? = null

    private var serverTrustGroupName: String? = null

    /**
     * @param value The name of the region where the resource is located.
     */
    @JvmName("gkubiwtjlahcpxwd")
    public suspend fun locationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.locationName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("duliqqjjbdssqrvr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server trust group.
     */
    @JvmName("iadslqpoupmcavre")
    public suspend fun serverTrustGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverTrustGroupName = mapped
    }

    internal fun build(): GetServerTrustGroupPlainArgs = GetServerTrustGroupPlainArgs(
        locationName = locationName ?: throw PulumiNullFieldException("locationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverTrustGroupName = serverTrustGroupName ?: throw
            PulumiNullFieldException("serverTrustGroupName"),
    )
}
