@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetSyncMemberPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property databaseName The name of the database on which the sync group is hosted.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property syncGroupName The name of the sync group on which the sync member is hosted.
 * @property syncMemberName The name of the sync member.
 */
public data class GetSyncMemberPlainArgs(
    public val databaseName: String,
    public val resourceGroupName: String,
    public val serverName: String,
    public val syncGroupName: String,
    public val syncMemberName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetSyncMemberPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetSyncMemberPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetSyncMemberPlainArgs.builder()
            .databaseName(databaseName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 }))
            .syncGroupName(syncGroupName.let({ args0 -> args0 }))
            .syncMemberName(syncMemberName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSyncMemberPlainArgs].
 */
@PulumiTagMarker
public class GetSyncMemberPlainArgsBuilder internal constructor() {
    private var databaseName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    private var syncGroupName: String? = null

    private var syncMemberName: String? = null

    /**
     * @param value The name of the database on which the sync group is hosted.
     */
    @JvmName("tfkxjhtsbemskyua")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("mhislkxmbndstovj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("yfxeotkjuhnkrygb")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    /**
     * @param value The name of the sync group on which the sync member is hosted.
     */
    @JvmName("lawnqjamkivkllan")
    public suspend fun syncGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.syncGroupName = mapped
    }

    /**
     * @param value The name of the sync member.
     */
    @JvmName("pcqbjsgvsovqwhqe")
    public suspend fun syncMemberName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.syncMemberName = mapped
    }

    internal fun build(): GetSyncMemberPlainArgs = GetSyncMemberPlainArgs(
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
        syncGroupName = syncGroupName ?: throw PulumiNullFieldException("syncGroupName"),
        syncMemberName = syncMemberName ?: throw PulumiNullFieldException("syncMemberName"),
    )
}
