@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.ManagedInstancePrivateEndpointPropertyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id Resource id of the private endpoint.
 */
public data class ManagedInstancePrivateEndpointPropertyArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.ManagedInstancePrivateEndpointPropertyArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.ManagedInstancePrivateEndpointPropertyArgs =
        com.pulumi.azurenative.sql.inputs.ManagedInstancePrivateEndpointPropertyArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedInstancePrivateEndpointPropertyArgs].
 */
@PulumiTagMarker
public class ManagedInstancePrivateEndpointPropertyArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource id of the private endpoint.
     */
    @JvmName("vkaoawxenmvokpgb")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource id of the private endpoint.
     */
    @JvmName("jfgituhmarhmkpwh")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): ManagedInstancePrivateEndpointPropertyArgs =
        ManagedInstancePrivateEndpointPropertyArgs(
            id = id,
        )
}
