@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.SkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An ARM Resource SKU.
 * @property capacity Capacity of the particular SKU.
 * @property family If the service has different generations of hardware, for the same SKU, then that can be captured here.
 * @property name The name of the SKU, typically, a letter + Number code, e.g. P3.
 * @property size Size of the particular SKU
 * @property tier The tier or edition of the particular SKU, e.g. Basic, Premium.
 */
public data class SkuArgs(
    public val capacity: Output<Int>? = null,
    public val family: Output<String>? = null,
    public val name: Output<String>,
    public val size: Output<String>? = null,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.SkuArgs =
        com.pulumi.azurenative.sql.inputs.SkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var family: Output<String>? = null

    private var name: Output<String>? = null

    private var size: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value Capacity of the particular SKU.
     */
    @JvmName("wpirxmlnpdacwjjf")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value If the service has different generations of hardware, for the same SKU, then that can be captured here.
     */
    @JvmName("twxtgstuhtnynkqt")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value The name of the SKU, typically, a letter + Number code, e.g. P3.
     */
    @JvmName("qddavybypgpdhjxt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Size of the particular SKU
     */
    @JvmName("dliqqbnfiujwjqnr")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value The tier or edition of the particular SKU, e.g. Basic, Premium.
     */
    @JvmName("fcuvkvfbognswwyc")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value Capacity of the particular SKU.
     */
    @JvmName("lviqmlkbufhggtwp")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value If the service has different generations of hardware, for the same SKU, then that can be captured here.
     */
    @JvmName("bgekcypmtudkbkqt")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The name of the SKU, typically, a letter + Number code, e.g. P3.
     */
    @JvmName("qquvcrwpcgtckuwh")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Size of the particular SKU
     */
    @JvmName("cevkwugtpfbeccgp")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The tier or edition of the particular SKU, e.g. Basic, Premium.
     */
    @JvmName("kpujwrgiailvjbek")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        capacity = capacity,
        family = family,
        name = name ?: throw PulumiNullFieldException("name"),
        size = size,
        tier = tier,
    )
}
