@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Azure Active Directory identity configuration for a resource.
 * @property tenantId The Azure Active Directory tenant id.
 * @property type The identity type
 * @property userAssignedIdentities The resource ids of the user assigned identities to use
 */
public data class DatabaseIdentityResponse(
    public val tenantId: String,
    public val type: String? = null,
    public val userAssignedIdentities: Map<String, DatabaseUserIdentityResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.DatabaseIdentityResponse): DatabaseIdentityResponse = DatabaseIdentityResponse(
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.sql.kotlin.outputs.DatabaseUserIdentityResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
