@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure Active Directory identity configuration for a resource.
 * @property clientId The Azure Active Directory client id.
 * @property principalId The Azure Active Directory principal id.
 */
public data class DatabaseUserIdentityResponse(
    public val clientId: String,
    public val principalId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.DatabaseUserIdentityResponse): DatabaseUserIdentityResponse = DatabaseUserIdentityResponse(
            clientId = javaType.clientId(),
            principalId = javaType.principalId(),
        )
    }
}
