@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * Per database settings of an elastic pool.
 * @property maxCapacity The maximum capacity any one database can consume.
 * @property minCapacity The minimum capacity all databases are guaranteed.
 */
public data class ElasticPoolPerDatabaseSettingsResponse(
    public val maxCapacity: Double? = null,
    public val minCapacity: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.ElasticPoolPerDatabaseSettingsResponse): ElasticPoolPerDatabaseSettingsResponse = ElasticPoolPerDatabaseSettingsResponse(
            maxCapacity = javaType.maxCapacity().map({ args0 -> args0 }).orElse(null),
            minCapacity = javaType.minCapacity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
