@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Read-only endpoint of the failover group instance.
 * @property failoverPolicy Failover policy of the read-only endpoint for the failover group.
 */
public data class FailoverGroupReadOnlyEndpointResponse(
    public val failoverPolicy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.FailoverGroupReadOnlyEndpointResponse): FailoverGroupReadOnlyEndpointResponse = FailoverGroupReadOnlyEndpointResponse(
            failoverPolicy = javaType.failoverPolicy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
