@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A short term retention policy.
 * @property diffBackupIntervalInHours The differential backup interval in hours. This is how many interval hours between each differential backup will be supported. This is only applicable to live databases but not dropped databases.
 * @property id Resource ID.
 * @property name Resource name.
 * @property retentionDays The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
 * @property type Resource type.
 */
public data class GetBackupShortTermRetentionPolicyResult(
    public val diffBackupIntervalInHours: Int? = null,
    public val id: String,
    public val name: String,
    public val retentionDays: Int? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetBackupShortTermRetentionPolicyResult): GetBackupShortTermRetentionPolicyResult = GetBackupShortTermRetentionPolicyResult(
            diffBackupIntervalInHours = javaType.diffBackupIntervalInHours().map({ args0 ->
                args0
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            retentionDays = javaType.retentionDays().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
